/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.database.DataSourceManager;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;

public abstract class DataSourceFragment {
    private static transient Log log = LogFactory.getLog((String)DataSourceFragment.class.getName());
    private String dataSourceName;

    public DataSourceFragment(String dataSourceName) {
        if (dataSourceName == null) {
            throw new NullPointerException();
        }
        this.dataSourceName = dataSourceName;
    }

    protected DataSource getDataSource() throws Exception {
        DataSourceManager dsMgr = CoreServices.lookup().getDataSourceManager();
        return dsMgr.getDatasource(this.dataSourceName);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void execute() throws Exception {
        new HibernateTxFragment(){

            @Override
            protected void txFragment(Session session) throws Exception {
                DataSource dataSource = DataSourceFragment.this.getDataSource();
                if (dataSource == null) {
                    DataSourceFragment.this.noDataSource();
                } else {
                    Connection conn = dataSource.getConnection();
                    DataSourceFragment.this.fragment(conn);
                }
            }
        }.execute();
    }

    protected abstract void fragment(Connection var1) throws Exception;

    protected void noDataSource() {
        log.error((Object)("There is no datasource with name " + this.dataSourceName + ". Ignoring fragment."));
    }
}

