/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.database.hibernate.HibernateInitializer;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;

@ApplicationScoped
public class DatabaseAutoSynchronizer {
    private static transient Log log = LogFactory.getLog((String)DatabaseAutoSynchronizer.class.getName());
    @Inject
    @Config(value="oracle=create-oracle.sql,mysql=create-mysql.sql,postgres=create-postgres.sql,sqlserver=create-sqlserver.sql,h2=create-h2.sql")
    private Properties createFiles = new Properties();
    @Inject
    @Config(value="select * from dashb_installed_module")
    private String testTableExistsSql;
    @Inject
    @Config(value="oracle, mysql, postgres, sqlserver, h2, hsql, oracle10g")
    private String[] supportedDatabases;
    public static final String CUSTOM_DELIMITER = "-- CUSTOM_DELIMITER";
    public static final String CUSTOM_DELIMITER_ENABLER = "-- ENABLE_CUSTOM_DELIMITER";
    public static final String DATABASE_CONFIG_DIR = "sql";
    @Inject
    @Config(value="delimiter //, //, , delimiter ;, GO")
    private String[] excludedScriptStatements;

    public String getTestTableExistsSql() {
        return this.testTableExistsSql;
    }

    public void setTestTableExistsSql(String testTableExistsSql) {
        this.testTableExistsSql = testTableExistsSql;
    }

    public Properties getCreateFiles() {
        return this.createFiles;
    }

    public void setCreateFiles(Properties createFiles) {
        this.createFiles = createFiles;
    }

    public String[] getSupportedDatabases() {
        return this.supportedDatabases;
    }

    public void setSupportedDatabases(String[] supportedDatabases) {
        this.supportedDatabases = supportedDatabases;
    }

    public String[] getExcludedScriptStatements() {
        return this.excludedScriptStatements;
    }

    public void setExcludedScriptStatements(String[] excludedScriptStatements) {
        this.excludedScriptStatements = excludedScriptStatements;
    }

    public void synchronize(HibernateInitializer hibernateInitializer) throws Exception {
        boolean tableExists;
        String databaseName = hibernateInitializer.getDatabaseName();
        if (this.isCurrentDatabaseSupported(databaseName) && !(tableExists = this.existsModulesTable(databaseName))) {
            this.createProductDatabase(databaseName);
        }
    }

    protected void createProductDatabase(String databaseName) throws Exception {
        String sqlFilePath = this.createDatabaseScriptPath(databaseName);
        this.runScript(sqlFilePath);
    }

    protected String createDatabaseScriptPath(String databaseName) {
        String sqlBasePath = Application.lookup().getBaseCfgDirectory() + "/" + DATABASE_CONFIG_DIR;
        databaseName = databaseName.startsWith("oracle") ? "oracle" : databaseName;
        return sqlBasePath + "/" + this.createFiles.get(databaseName);
    }

    protected void runScript(String filePath) throws Exception {
        File f = new File(filePath);
        if (f.exists() && f.isFile()) {
            log.warn((Object)("Creating database. Running file " + filePath));
            BufferedReader reader = new BufferedReader(new FileReader(f));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            this.runDDL(sb.toString());
        }
    }

    private String[] splitString(String str, String delims) {
        if (str == null) {
            return null;
        }
        if (str.equals("") || delims == null || delims.length() == 0) {
            return new String[]{str};
        }
        Vector<String> v = new Vector<String>();
        int pos = 0;
        int newpos = str.indexOf(delims, pos);
        while (newpos != -1) {
            v.addElement(str.substring(pos, newpos));
            pos = newpos + delims.length();
            newpos = str.indexOf(delims, pos);
        }
        v.addElement(str.substring(pos));
        String[] s = new String[v.size()];
        int cnt = s.length;
        for (int i = 0; i < cnt; ++i) {
            s[i] = ((String)v.elementAt(i)).trim();
        }
        return s;
    }

    protected void runDDL(String ddl) throws Exception {
        String separator = ";";
        if (ddl.startsWith(CUSTOM_DELIMITER_ENABLER)) {
            separator = CUSTOM_DELIMITER;
        }
        String[] statements = this.splitString(ddl, separator);
        for (int i = 0; i < statements.length; ++i) {
            final String ddlStatement = this.removeComments(statements[i]);
            if (ArrayUtils.contains((Object[])this.getExcludedScriptStatements(), (Object)ddlStatement)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running statement: " + ddlStatement));
            }
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Work w = new Work(){

                        public void execute(Connection connection) throws SQLException {
                            Statement statement = null;
                            try {
                                statement = connection.createStatement();
                                statement.execute(ddlStatement);
                            }
                            catch (SQLException e) {
                                log.error((Object)("Error executing " + ddlStatement + ": "), (Throwable)e);
                                throw e;
                            }
                            finally {
                                if (statement != null) {
                                    statement.close();
                                }
                            }
                        }
                    };
                    session.doWork(w);
                    session.flush();
                }
            }.execute();
        }
    }

    protected String removeComments(String ddlStatement) {
        StringBuffer sb = new StringBuffer();
        BufferedReader strreader = new BufferedReader(new StringReader(ddlStatement));
        String line = null;
        try {
            while ((line = strreader.readLine()) != null) {
                if (line.trim().startsWith("--")) continue;
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            log.error((Object)"Error: ", (Throwable)e);
        }
        return sb.toString().trim();
    }

    protected boolean existsModulesTable(String databaseName) throws Exception {
        final boolean[] returnValue = new boolean[]{false};
        new HibernateTxFragment(true){

            @Override
            protected void txFragment(Session session) throws Exception {
                Work w = new Work(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(Connection connection) throws SQLException {
                        block9: {
                            Statement statement = null;
                            try {
                                statement = connection.createStatement();
                                statement.execute(DatabaseAutoSynchronizer.this.getTestTableExistsSql());
                                returnValue[0] = true;
                                log.debug((Object)"Execution of getTestTableExistsSql() query didn't throw any error. Database might be installed.");
                            }
                            catch (SQLException e) {
                                this.markAsRollbackOnly();
                            }
                            catch (UndeclaredThrowableException e) {
                                if (e.getCause() != null && e.getCause().getCause() instanceof SQLException) {
                                    this.markAsRollbackOnly();
                                    break block9;
                                }
                                throw e;
                            }
                            finally {
                                if (statement != null) {
                                    statement.close();
                                }
                            }
                        }
                    }
                };
                session.doWork(w);
            }
        }.execute();
        return returnValue[0];
    }

    public boolean isCurrentDatabaseSupported(String databaseName) {
        for (int i = 0; this.supportedDatabases != null && i < this.supportedDatabases.length; ++i) {
            if (!databaseName.equals(this.supportedDatabases[i])) continue;
            return true;
        }
        return false;
    }
}

