/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.CacheElement;
import org.jboss.dashboard.factory.BasicFactoryElement;

public class CacheOptions
extends BasicFactoryElement {
    private static transient Log log = LogFactory.getLog((String)CacheOptions.class.getName());
    private CacheElement defaultCacheElement;
    public CacheElement[] cacheElements;
    public String[] cacheNamesToCreate;

    public CacheElement getDefaultCacheElement() {
        return this.defaultCacheElement;
    }

    public void setDefaultCacheElement(CacheElement defaultCacheElement) {
        this.defaultCacheElement = defaultCacheElement;
    }

    public CacheElement getElement(String name) {
        for (CacheElement cacheElement : this.cacheElements) {
            if (!cacheElement.getName().equals(name)) continue;
            return cacheElement;
        }
        if (ArrayUtils.contains((Object[])this.cacheNamesToCreate, (Object)name)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache \"" + name + "\" was lazily tuned, and may be undersized. Consider manual tuning."));
            }
            return this.defaultCacheElement;
        }
        log.warn((Object)("Unable to find cache configuration for \"" + name + "\". " + "Using defaults. " + "You should create a Factory component similar to: \n\n" + "\t$class=" + CacheElement.class.getName() + "\n" + "\t$scope=global\n" + "\tname=" + name + "\n" + "\tmaxElementsInMemory=xxxx\n\n" + "and add it to the cacheElements property of org.jboss.dashboard.database.cache.CacheOptions component."));
        return this.defaultCacheElement;
    }
}

