/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache.custom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.custom.CacheStatistics;

public class CacheMonitor {
    private static transient Log log = LogFactory.getLog(CacheMonitor.class);
    private long numHits = 0L;
    private long numMisses = 0L;
    private long currentCacheOccupation = 0L;
    private long numOperations = 0L;
    private float averageOccupation = 0.0f;
    private long cacheSize;

    protected CacheMonitor(long cacheSize) {
        this.cacheSize = cacheSize;
        this.resetStatistics();
    }

    protected void resetStatistics() {
        this.numHits = 0L;
        this.numMisses = 0L;
        this.numOperations = 0L;
        this.currentCacheOccupation = 0L;
        this.averageOccupation = 0.0f;
    }

    public CacheStatistics getCacheStatistics() {
        return new CacheStatistics(){

            @Override
            public float getHitRate() {
                if (CacheMonitor.this.numHits + CacheMonitor.this.numMisses == 0L) {
                    return 0.0f;
                }
                return 100.0f * (float)CacheMonitor.this.numHits / (float)(CacheMonitor.this.numHits + CacheMonitor.this.numMisses);
            }

            @Override
            public float getAverageOccupation() {
                return CacheMonitor.this.averageOccupation;
            }

            @Override
            public float getAverageOccupationRate() {
                return this.getAverageOccupation() * 100.0f / (float)CacheMonitor.this.cacheSize;
            }

            @Override
            public long getCacheSize() {
                return CacheMonitor.this.cacheSize;
            }

            @Override
            public long getNumOperations() {
                return CacheMonitor.this.numOperations;
            }

            @Override
            public long getNumReads() {
                return CacheMonitor.this.numHits + CacheMonitor.this.numMisses;
            }
        };
    }

    public synchronized void elementAdded() {
        ++this.currentCacheOccupation;
        ++this.numOperations;
        this.averageOccupation += (float)this.currentCacheOccupation * 1.0f / (float)this.numOperations;
    }

    public synchronized void elementEvicted() {
        --this.currentCacheOccupation;
        ++this.numOperations;
        this.averageOccupation = ((float)this.numOperations - 1.0f) / (float)this.numOperations * this.averageOccupation + (float)this.currentCacheOccupation * 1.0f / (float)this.numOperations;
    }

    public synchronized void allElementsEvicted() {
        this.currentCacheOccupation = 0L;
    }

    public synchronized void registerCacheHit() {
        ++this.numHits;
    }

    public synchronized void registerCacheMiss() {
        ++this.numMisses;
    }
}

