/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache.custom;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.custom.CacheMonitor;
import org.jboss.dashboard.database.cache.custom.CacheStatistics;
import org.jboss.dashboard.database.cache.custom.StatisticsObjectCache;

public class FIFOCache
implements StatisticsObjectCache {
    Log log = LogFactory.getLog(this.getClass());
    private CacheMonitor cacheMonitor;
    private String type;
    private int size;
    private Map<Serializable, Object> cache = new Hashtable<Serializable, Object>();
    private List<Serializable> elements = new LinkedList<Serializable>();

    public FIFOCache(boolean monitorizeCaches, int size) {
        if (monitorizeCaches) {
            this.cacheMonitor = new CacheMonitor(size);
        }
    }

    public void setSize(int newSize) {
        this.size = newSize;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache type set to '" + type + "'."));
        }
        this.type = type;
    }

    @Override
    public void put(Serializable key, Object object) {
        boolean replaced;
        boolean bl = replaced = this.cache.put(key, object) != null;
        if (replaced) {
            this.elements.add(key);
        }
        if (this.elements.size() > this.size) {
            this.clear(this.elements.get(0));
        }
        if (this.cacheMonitor != null) {
            this.cacheMonitor.elementAdded();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Put " + this.type + " #" + key + " in to cache."));
        }
    }

    @Override
    public Object get(Serializable key) {
        Object object = this.cache.get(key);
        if (object != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got " + this.type + " #" + key + " from cache."));
        }
        if (this.cacheMonitor != null) {
            if (object != null) {
                this.cacheMonitor.registerCacheHit();
            } else {
                this.cacheMonitor.registerCacheMiss();
            }
        }
        return object;
    }

    @Override
    public Object clear(Serializable key) {
        Object o;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cleared " + this.type + " #" + key + " from cache."));
        }
        if ((o = this.cache.remove(key)) != null) {
            this.elements.remove(key);
        }
        if (o != null && this.cacheMonitor != null) {
            this.cacheMonitor.elementEvicted();
        }
        return o;
    }

    @Override
    public void clearAll() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cleared entire " + this.type + " cache."));
        }
        this.cache.clear();
        this.elements.clear();
        if (this.cacheMonitor != null) {
            this.cacheMonitor.allElementsEvicted();
        }
    }

    @Override
    public CacheStatistics getCacheStatistics() {
        if (this.cacheMonitor != null) {
            return this.cacheMonitor.getCacheStatistics();
        }
        return null;
    }
}

