/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.hibernate;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.annotation.Priority;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.io.DirectoriesScanner;
import org.jboss.dashboard.database.DatabaseAutoSynchronizer;
import org.jboss.dashboard.database.cache.CacheConfigurationGenerator;
import org.jboss.dashboard.database.cache.CacheConfigurationManager;
import org.jboss.dashboard.database.hibernate.HibernateSessionFactoryProvider;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.jboss.dashboard.factory.Factory;

@ApplicationScoped
public class HibernateInitializer
implements Startable {
    private static transient Log log = LogFactory.getLog((String)HibernateInitializer.class.getName());
    private static final String HIBERNATE_FILE_EXTENSION = "hbm.xml";
    @Inject
    @Config(value="true")
    protected boolean performNativeToHiloReplace;
    @Inject
    @Config(value="org.hibernate.dialect.MySQLDialect, org.hibernate.dialect.SQLServerDialect")
    protected String[] nativeToHiloReplaceableDialects;
    @Inject
    @Config(value="true")
    protected boolean enableDatabaseStructureVerification = true;
    @Inject
    @Config(value="true")
    protected boolean enableDatabaseAutoSynchronization = true;
    @Inject
    @Config(value="org.jboss.dashboard.ui.resources.Envelope,org.jboss.dashboard.ui.resources.Skin,org.jboss.dashboard.ui.resources.Layout,org.jboss.dashboard.ui.resources.ResourceGallery,org.jboss.dashboard.ui.resources.GraphicElement")
    protected String[] databaseStructureVerificationExcludedClassNames;
    @Inject
    protected HibernateSessionFactoryProvider hibernateSessionFactoryProvider;
    @Inject
    protected DatabaseAutoSynchronizer databaseAutoSynchronizer;
    protected Configuration hbmConfig;
    protected String databaseName;
    protected boolean c3p0Enabled = true;
    protected boolean cacheEnabled = true;
    protected List processedJars = new ArrayList();

    public Properties getHibernateProperties() {
        return (Properties)Factory.lookup("org.jboss.dashboard.database.HibernateProperties");
    }

    public CacheConfigurationManager getCacheConfigurationManager() {
        return (CacheConfigurationManager)Factory.lookup("org.jboss.dashboard.database.cache.CacheConfigurationManager");
    }

    public DatabaseAutoSynchronizer getDatabaseAutoSynchronizer() {
        return this.databaseAutoSynchronizer;
    }

    public boolean isEnableDatabaseStructureVerification() {
        return this.enableDatabaseStructureVerification;
    }

    public void setEnableDatabaseStructureVerification(boolean enableDatabaseStructureVerification) {
        this.enableDatabaseStructureVerification = enableDatabaseStructureVerification;
    }

    public Configuration getHbmConfig() {
        return this.hbmConfig;
    }

    public boolean isPerformNativeToHiloReplace() {
        return this.performNativeToHiloReplace;
    }

    public void setPerformNativeToHiloReplace(boolean performNativeToHiloReplace) {
        this.performNativeToHiloReplace = performNativeToHiloReplace;
    }

    public String[] getNativeToHiloReplaceableDialects() {
        return this.nativeToHiloReplaceableDialects;
    }

    public void setNativeToHiloReplaceableDialects(String[] nativeToHiloReplaceableDialects) {
        this.nativeToHiloReplaceableDialects = nativeToHiloReplaceableDialects;
    }

    public String[] getDatabaseStructureVerificationExcludedClassNames() {
        return this.databaseStructureVerificationExcludedClassNames;
    }

    public void setDatabaseStructureVerificationExcludedClassNames(String[] databaseStructureVerificationExcludedClassNames) {
        this.databaseStructureVerificationExcludedClassNames = databaseStructureVerificationExcludedClassNames;
    }

    public boolean isC3p0Enabled() {
        return this.c3p0Enabled;
    }

    public void setC3p0Enabled(boolean c3p0Enabled) {
        this.c3p0Enabled = c3p0Enabled;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isEnableDatabaseAutoSynchronization() {
        return this.enableDatabaseAutoSynchronization;
    }

    public void setEnableDatabaseAutoSynchronization(boolean enableDatabaseAutoSynchronization) {
        this.enableDatabaseAutoSynchronization = enableDatabaseAutoSynchronization;
    }

    public SessionFactory getSessionFactory() {
        return this.hibernateSessionFactoryProvider.getSessionFactory();
    }

    @Override
    public Priority getPriority() {
        return Priority.URGENT;
    }

    @Override
    public void start() throws Exception {
        this.getCacheConfigurationManager().initializeCaches();
        Properties properties = this.getHibernateProperties();
        this.processHibernateProperties(properties);
        System.getProperties().putAll((Map<?, ?>)properties);
        this.hbmConfig = new Configuration();
        this.hbmConfig.setProperties(properties);
        String dialect = properties.getProperty("hibernate.dialect");
        String dialectName = dialect.substring(dialect.lastIndexOf(46) + 1);
        if (dialectName.endsWith("Dialect")) {
            dialectName = dialectName.substring(0, dialectName.length() - 7);
        }
        this.databaseName = (dialectName = dialectName.toLowerCase()).equals("postgresql") ? "postgres" : dialectName;
        this.loadFiles(this.hbmConfig);
        this.hibernateSessionFactoryProvider.setSessionFactory(this.hbmConfig.buildSessionFactory());
        if (this.isEnableDatabaseAutoSynchronization() && this.getDatabaseAutoSynchronizer() != null) {
            this.getDatabaseAutoSynchronizer().synchronize(this);
        }
        if (this.enableDatabaseStructureVerification) {
            this.verifyHibernateConfig();
        }
    }

    protected void processHibernateProperties(Properties p) {
        if (!this.isCacheEnabled()) {
            log.warn((Object)"\nHIBERNATE CACHE DISABLED");
        }
        if (!this.isC3p0Enabled()) {
            log.warn((Object)"\nHIBERNATE C3P0 DISABLED");
        }
        Iterator<Object> it = p.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!this.isC3p0Enabled() && key.startsWith("hibernate.c3p0")) {
                it.remove();
            }
            if (this.isCacheEnabled() || !key.startsWith("hibernate.cache")) continue;
            it.remove();
        }
        if (p.containsKey("hibernate.connection.datasource")) {
            p.remove("hibernate.connection.url");
            p.remove("hibernate.connection.username");
            p.remove("hibernate.connection.password");
        }
    }

    protected void verifyHibernateConfig() throws Exception {
        new HibernateTxFragment(){

            @Override
            protected void txFragment(Session session) throws Exception {
                Map metadata = session.getSessionFactory().getAllClassMetadata();
                for (final AbstractEntityPersister persister : metadata.values()) {
                    final String className = persister.getName();
                    if (ArrayUtils.contains((Object[])HibernateInitializer.this.getDatabaseStructureVerificationExcludedClassNames(), (Object)className)) continue;
                    log.debug((Object)("Verifying: " + className));
                    new HibernateTxFragment(true){

                        @Override
                        protected void txFragment(Session session) throws Exception {
                            try {
                                boolean usingOracle = HibernateInitializer.this.isOracleDatabase();
                                Query query = session.createQuery("from " + className + " c " + (usingOracle ? " where rownum < 6" : ""));
                                if (!usingOracle) {
                                    query.setMaxResults(5);
                                }
                                query.list();
                            }
                            catch (Exception e) {
                                log.error((Object)("Structure verification error for class " + className));
                                log.error((Object)("Error seems to affect table named " + persister.getTableName()));
                                log.error((Object)"Please verify that all required database upgrades/creates are applied. Following stack trace may help you to determine the current error cause: ", (Throwable)e);
                            }
                        }
                    }.execute();
                }
            }
        }.execute();
    }

    protected void loadFiles(Configuration hbmConfig) throws IOException {
        List<String> modules = Application.lookup().getGlobalFactory().getModules();
        String libPath = Application.lookup().getBaseAppDirectory() + File.separator + "WEB-INF" + File.separator + "lib";
        File libDir = new File(libPath);
        File[] jars = new DirectoriesScanner("jar").findFiles(libDir);
        for (int i = 0; i < jars.length; ++i) {
            File jar = jars[i];
            for (String moduleName : modules) {
                String jarName = jar.getName();
                if (this.processedJars.contains(jarName) || !jarName.startsWith(moduleName)) continue;
                this.loadFiles(hbmConfig, jar);
                this.processedJars.add(jarName);
            }
        }
    }

    protected void loadFiles(Configuration hbmConfig, File jarFile) throws IOException {
        ZipFile zf = new ZipFile(jarFile);
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (!entry.getName().endsWith(HIBERNATE_FILE_EXTENSION) || entry.isDirectory()) continue;
            InputStream is = zf.getInputStream(entry);
            String xml = this.readXMLForFile(is);
            xml = this.processXMLContents(entry.getName(), xml);
            hbmConfig.addXML(xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readXMLForFile(InputStream is) throws IOException {
        String string;
        block7: {
            BufferedReader reader = null;
            try {
                String lineRead;
                reader = new BufferedReader(new InputStreamReader(is));
                StringBuffer fileContents = new StringBuffer();
                while ((lineRead = reader.readLine()) != null) {
                    fileContents.append(lineRead);
                }
                string = fileContents.toString();
                if (reader == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error((Object)"Error:", (Throwable)e);
                    return null;
                }
            }
            reader.close();
        }
        return string;
    }

    protected String processXMLContents(String fileName, String fileContent) {
        if (this.isPerformNativeToHiloReplace() && this.getHibernateProperties() != null && ArrayUtils.contains((Object[])this.getNativeToHiloReplaceableDialects(), (Object)this.getHibernateProperties().getProperty("hibernate.dialect"))) {
            String line = "class=\"hilo\"><param name=\"table\">hibernate_unique_key</param><param name=\"column\">next_hi</param><param name=\"max_lo\">0</param></generator>";
            fileContent = StringUtils.replace((String)fileContent, (String)"class=\"native\"/>", (String)line);
            fileContent = StringUtils.replace((String)fileContent, (String)"class=\"native\" />", (String)line);
        }
        CacheConfigurationGenerator configGenerator = this.getCacheConfigurationManager().getConfigGenerator();
        String cacheUsage = null;
        if (configGenerator != null) {
            cacheUsage = configGenerator.getCacheUsage();
        }
        if (cacheUsage != null) {
            String oldCacheUsage = "<cache usage=\"transactional\"/>";
            String newCacheUsage = "<cache usage=\"" + cacheUsage + "\"/>";
            fileContent = StringUtils.replace((String)fileContent, (String)oldCacheUsage, (String)newCacheUsage);
        }
        return fileContent;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public synchronized void evictAllCaches() {
        if (!this.getCacheConfigurationManager().freeAllCache()) {
            SessionFactory sf = this.getSessionFactory();
            sf.evictQueries();
            Map metadata = this.getSessionFactory().getAllClassMetadata();
            for (Object o : metadata.values()) {
                AbstractEntityPersister persister = (AbstractEntityPersister)o;
                String className = persister.getName();
                sf.evictEntity(className);
            }
        }
    }

    public synchronized boolean createCustomCacheRegion(String regionName) {
        return this.getCacheConfigurationManager().createCustomCacheRegion(regionName);
    }

    public boolean isOracleDatabase() {
        return this.isDatabase("Oracle");
    }

    public boolean isPostgresDatabase() {
        return this.isDatabase("Postgre");
    }

    public boolean isSQLServerDatabase() {
        return this.isDatabase("SQLServer");
    }

    public boolean isMySQLDatabase() {
        return this.isDatabase("MySQL");
    }

    public boolean isH2Database() {
        return this.isDatabase("H2");
    }

    protected boolean isDatabase(String dbId) {
        String dialect = this.getHibernateProperties().getProperty("hibernate.dialect");
        return dialect.indexOf(dbId) != -1 || dialect.indexOf(dbId.toLowerCase()) != -1;
    }
}

