/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.error;

import java.util.LinkedList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.error.ApplicationError;
import org.jboss.dashboard.error.BusinessError;
import org.jboss.dashboard.error.ErrorReport;
import org.jboss.dashboard.error.ErrorTrace;
import org.jboss.dashboard.error.TechnicalError;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.Profiler;
import org.jboss.dashboard.profiler.ThreadProfile;

@ApplicationScoped
public class ErrorManager {
    private static transient Log log = LogFactory.getLog((String)ErrorManager.class.getName());
    @Inject
    @Config(value="true")
    protected boolean logErrorReportEnabled;
    @Inject
    @Config(value="true")
    protected boolean logDBInterlockThreadsEnabled;

    public static ErrorManager lookup() {
        return CoreServices.lookup().getErrorManager();
    }

    public boolean isLogErrorReportEnabled() {
        return this.logErrorReportEnabled;
    }

    public void setLogErrorReportEnabled(boolean logErrorReportEnabled) {
        this.logErrorReportEnabled = logErrorReportEnabled;
    }

    public boolean isLogDBInterlockThreadsEnabled() {
        return this.logDBInterlockThreadsEnabled;
    }

    public void setLogDBInterlockThreadsEnabled(boolean logDBInterlockThreadsEnabled) {
        this.logDBInterlockThreadsEnabled = logDBInterlockThreadsEnabled;
    }

    public void throwTechnicalError(String message, Throwable cause) {
        throw new TechnicalError(message, cause);
    }

    public void throwBusinessError(String title, String message) {
        throw new BusinessError(0, title, message);
    }

    public void throwBusinessWarning(String title, String message) {
        throw new BusinessError(1, title, message);
    }

    public void throwBusinessInfo(String title, String message) {
        throw new BusinessError(2, title, message);
    }

    public ApplicationError getApplicationErrorCause(Throwable e) {
        LinkedList<ApplicationError> appErrors = new LinkedList<ApplicationError>();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ApplicationError)) continue;
            appErrors.add((ApplicationError)cause);
        }
        if (appErrors.isEmpty()) {
            return null;
        }
        return (ApplicationError)appErrors.getLast();
    }

    public boolean isDBInterlockException(Throwable e) {
        Throwable root = e;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        if (root.getClass().getName().endsWith("SQLServerException") && root.getMessage().indexOf("en bloqueo recursos con otro proceso y fue elegida como sujeto del interbloqueo") != -1) {
            return true;
        }
        if (root.getClass().getName().endsWith("PSQLException") && root.getMessage().indexOf("ERROR: no se pudo serializar el acceso debido a un update concurrente") != -1) {
            return true;
        }
        return root.getClass().getName().endsWith("SQLException") && root.getMessage().indexOf("ORA-00060: detectado interbloqueo mientras se esperaba un recurso") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorReport notifyError(Throwable t, boolean doLog) {
        ThreadProfile threadProfile = Profiler.lookup().getCurrentThreadProfile();
        if (threadProfile.getErrorReport() != null) {
            return threadProfile.getErrorReport();
        }
        ErrorReport report = new ErrorReport();
        report.setId(String.valueOf(System.currentTimeMillis()));
        report.setException(t);
        CodeBlockTrace trace = new ErrorTrace(report).begin();
        try {
            threadProfile.setErrorReport(report);
            if (doLog) {
                this.logError(report);
            }
        }
        finally {
            trace.end();
        }
        return report;
    }

    public void logError(ErrorReport report) {
        ApplicationError appError = this.getApplicationErrorCause(report.getException());
        if (appError == null) {
            if (this.logErrorReportEnabled) {
                log.error((Object)("UNEXPECTED ERROR.\n" + report.printContext(0)));
            }
            if (this.logDBInterlockThreadsEnabled && this.isDBInterlockException(report.getRootException())) {
                log.error((Object)Profiler.lookup().printActiveThreadsReport());
            }
        }
    }
}

