/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.error.ApplicationError;
import org.jboss.dashboard.error.BusinessError;
import org.jboss.dashboard.error.ErrorManager;
import org.jboss.dashboard.factory.BasicFactoryElement;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.Profiler;

public class ErrorReport
extends BasicFactoryElement {
    protected Date date = new Date();
    protected String id = null;
    protected Throwable exception = null;
    protected CodeBlockTrace codeBlock;
    protected static transient DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);

    public static ErrorReport getCurrentThreadError() {
        return Profiler.lookup().getCurrentThreadProfile().getErrorReport();
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Throwable getRootException() {
        return this.getRootCause(this.exception);
    }

    protected Throwable getRootCause(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable root = t.getCause();
        if (root == null) {
            if (t instanceof ServletException) {
                root = ((ServletException)t).getRootCause();
            }
            if (t instanceof JspException) {
                root = ((JspException)t).getRootCause();
            }
        }
        if (root == null) {
            return t;
        }
        return this.getRootCause(root);
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public CodeBlockTrace getCodeBlock() {
        return this.codeBlock;
    }

    public void setCodeBlock(CodeBlockTrace codeBlock) {
        this.codeBlock = codeBlock;
    }

    public String printContext(int indent) {
        StringBuffer buf = new StringBuffer();
        if (this.codeBlock == null) {
            ErrorReport.appendIndent(buf, indent);
            buf.append("Error id='").append(this.id).append("'\n");
            ErrorReport.appendIndent(buf, indent);
            buf.append("Error date='").append(dateFormat.format(this.date)).append("'\n");
            ErrorReport.appendIndent(buf, indent);
            buf.append("\r\n");
            ErrorReport.appendIndent(buf, indent);
            buf.append(this.printExceptionTrace());
        } else {
            buf.append(this.codeBlock.printContext(true, "=", "\n", indent));
        }
        return buf.toString();
    }

    public String printExceptionTrace() {
        StringWriter sw = new StringWriter();
        this.getRootException().printStackTrace(new PrintWriter(sw));
        return sw.getBuffer().toString();
    }

    public static void appendIndent(StringBuffer out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.append("\t");
        }
    }

    public boolean isBusinessAppError() {
        ApplicationError appError = ErrorManager.lookup().getApplicationErrorCause(this.exception);
        return appError != null && appError instanceof BusinessError;
    }

    public boolean isTechnicalAppError() {
        ApplicationError appError = ErrorManager.lookup().getApplicationErrorCause(this.exception);
        return appError != null && appError instanceof BusinessError;
    }

    protected String getUnexpectedErrorTitle() {
        ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.error.messages", LocaleManager.currentLocale());
        return i18n.getString("errorTitle");
    }

    protected String getUnexpectedErrorMessage() {
        ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.error.messages", LocaleManager.currentLocale());
        return i18n.getString("errorMessage");
    }

    public String printErrorTitle() {
        ApplicationError appError = ErrorManager.lookup().getApplicationErrorCause(this.exception);
        if (this.isBusinessAppError()) {
            return ((BusinessError)appError).getTitle();
        }
        return this.getUnexpectedErrorTitle();
    }

    public String printErrorMessage() {
        ApplicationError appError = ErrorManager.lookup().getApplicationErrorCause(this.exception);
        if (appError != null) {
            return appError.getMessage();
        }
        return this.getUnexpectedErrorMessage();
    }

    public static void main(String[] args) {
        ErrorReport report = new ErrorReport();
        report.setException(new RuntimeException("ERROR"));
        report.setId(String.valueOf(System.currentTimeMillis()));
        System.out.println(report.toString());
    }
}

