/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.error;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.dashboard.error.ErrorReport;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.CodeBlockType;
import org.jboss.dashboard.profiler.CoreCodeBlockTypes;
import org.jboss.dashboard.profiler.Profiler;
import org.jboss.dashboard.profiler.ThreadProfile;

public class ErrorTrace
extends CodeBlockTrace {
    public static final String ERROR_ID = "Error id";
    public static final String ERROR_DATE = "Error date";
    public static final String ERROR_STACKTRACE = "Error stack trace";
    protected ErrorReport error;
    protected Map<String, Object> context;

    public ErrorTrace(ErrorReport error) {
        super(error.getId());
        this.error = error;
        this.context = new LinkedHashMap<String, Object>();
        this.context.put(ERROR_ID, error.getId());
        this.context.put(ERROR_DATE, error.getDate());
        this.context.put(ERROR_STACKTRACE, error.printExceptionTrace());
        ThreadProfile threadProfile = Profiler.lookup().getCurrentThreadProfile();
        if (threadProfile != null) {
            threadProfile.addContextProperties(this.context);
        }
    }

    @Override
    public CodeBlockType getType() {
        return CoreCodeBlockTypes.ERROR;
    }

    @Override
    public String getDescription() {
        return this.error.getRootException().getMessage();
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }
}

