/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.commons.text.StringUtil;
import org.jboss.dashboard.factory.Component;
import org.jboss.dashboard.factory.PropertyChangeProcessingInstruction;

public class PropertySubstractProcessingInstruction
extends PropertyChangeProcessingInstruction {
    private static transient Log log = LogFactory.getLog((String)PropertySubstractProcessingInstruction.class.getName());

    public PropertySubstractProcessingInstruction(Component component, String propertyName, String propertyValue) {
        super(component, propertyName, propertyValue);
    }

    @Override
    public Object getValueAfterChange(Object originalValue, Class expectedClass) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing instruction " + this + " on value " + originalValue + " (" + expectedClass + ")"));
        }
        Object valueToSubstract = null;
        Object currentValue = originalValue;
        currentValue = currentValue == null ? this.getNewInstanceForClass(expectedClass) : currentValue;
        valueToSubstract = this.getValueForParameter(this.getPropertyValue(), expectedClass);
        if (valueToSubstract != null) {
            if (expectedClass.isArray()) {
                if (((Object[])valueToSubstract).length == 0) {
                    return null;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.addAll(Arrays.asList((Object[])currentValue));
                list.removeAll(Arrays.asList((Object[])valueToSubstract));
                return list.toArray((Object[])this.getBaseArray(expectedClass.getComponentType(), list.size()));
            }
            if (expectedClass.equals(Integer.TYPE)) {
                return new Integer((Integer)currentValue - (Integer)valueToSubstract);
            }
            if (expectedClass.equals(Long.TYPE)) {
                return new Long((Long)currentValue - (Long)valueToSubstract);
            }
            if (expectedClass.equals(Double.TYPE)) {
                return new Double((Double)currentValue - (Double)valueToSubstract);
            }
            if (expectedClass.equals(Float.TYPE)) {
                return new Float(((Float)currentValue).floatValue() - ((Float)valueToSubstract).floatValue());
            }
            if (expectedClass.equals(Byte.TYPE)) {
                return new Byte((byte)((Byte)currentValue - (Byte)valueToSubstract));
            }
            if (expectedClass.equals(Short.TYPE)) {
                return new Short((short)((Short)currentValue - (Short)valueToSubstract));
            }
            if (expectedClass.equals(Integer.class)) {
                return new Integer((Integer)currentValue - (Integer)valueToSubstract);
            }
            if (expectedClass.equals(Long.class)) {
                return new Long((Long)currentValue - (Long)valueToSubstract);
            }
            if (expectedClass.equals(Double.class)) {
                return new Double((Double)currentValue - (Double)valueToSubstract);
            }
            if (expectedClass.equals(Float.class)) {
                return new Float(((Float)currentValue).floatValue() - ((Float)valueToSubstract).floatValue());
            }
            if (expectedClass.equals(Byte.class)) {
                return new Byte((byte)((Byte)currentValue - (Byte)valueToSubstract));
            }
            if (expectedClass.equals(Short.class)) {
                return new Short((short)((Short)currentValue - (Short)valueToSubstract));
            }
            if (expectedClass.equals(String.class)) {
                if ("".equals(valueToSubstract)) {
                    return null;
                }
                if (((String)currentValue).indexOf((String)valueToSubstract) != -1) {
                    currentValue = StringUtil.replaceAll((String)currentValue, (String)valueToSubstract, "");
                }
            } else {
                log.error((Object)("Addition not supported for class " + expectedClass + ". Ignoring property " + this.getPropertyName() + "+=" + this.getPropertyValue()));
            }
        }
        return originalValue;
    }

    public String toString() {
        return "do{" + this.getPropertyName() + "-=" + this.getPropertyValue() + "}";
    }
}

