/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.log;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LoggerSet {
    public static Level[] LEVELS_ALL = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
    public static Level[] LEVELS_NODEBUG = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO};
    public static final LoggerSet PROTOTYPE = new LoggerSet("", null, "com.package1\ncom.package2\n...", true);
    public static final LoggerSet ROOT = new LoggerSet("ROOT", Logger.getRootLogger(), false, LEVELS_NODEBUG);
    protected Long id = (long)((double)System.currentTimeMillis() * Math.random());
    protected String name;
    protected Level level;
    protected boolean editable;
    protected List<Logger> loggers;
    protected Level[] allowedLevels;

    public LoggerSet(String name, Level level, boolean editable) {
        this(name, level, null, editable, LEVELS_ALL);
    }

    public LoggerSet(String name, Logger logger, boolean editable) {
        this(name, logger, editable, LEVELS_ALL);
    }

    public LoggerSet(String name, Level level, String loggers, boolean editable) {
        this(name, level, loggers, editable, LEVELS_ALL);
    }

    LoggerSet(String name, Logger logger, boolean editable, Level[] allowedLevels) {
        this(name, logger.getLevel(), null, editable, allowedLevels);
        this.loggers.add(logger);
    }

    LoggerSet(String name, Level level, String loggers, boolean editable, Level[] allowedLevels) {
        this.name = name;
        this.level = level;
        this.editable = editable;
        this.loggers = new ArrayList<Logger>();
        this.allowedLevels = allowedLevels;
        this.parseLoggers(loggers);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
        for (Logger logger : this.loggers) {
            logger.setLevel(level);
        }
    }

    public Level[] getAllowedLevels() {
        return this.allowedLevels;
    }

    public void setAllowedLevels(Level[] allowedLevels) {
        this.allowedLevels = allowedLevels;
    }

    public void parseLoggers(String loggersStr) {
        this.loggers.clear();
        if (!StringUtils.isBlank((String)loggersStr)) {
            String[] loggerNames;
            for (String loggerName : loggerNames = StringUtils.split((String)loggersStr, (String)"\n")) {
                if (StringUtils.isBlank((String)(loggerName = loggerName.trim()))) continue;
                Logger logger = Logger.getLogger((String)loggerName);
                logger.setLevel(this.level);
                this.loggers.add(logger);
            }
        }
    }

    public String printLoggers(String separator) {
        StringBuffer buf = new StringBuffer();
        for (Logger logger : this.loggers) {
            if (buf.length() > 0) {
                buf.append(separator);
            }
            buf.append(logger.getName());
        }
        return buf.toString();
    }
}

