/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.misc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.dashboard.commons.text.StringUtil;

public class ReflectionUtils {
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    private static final String PREFIX_IS = "is";

    public static Object getPrivateField(Object o, String fieldName) {
        Field[] fields = o.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            try {
                fields[i].setAccessible(true);
                return fields[i].get(o);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }
        return null;
    }

    public static Object invokePrivateMethod(Object o, String methodName, Object[] params) {
        Method[] methods = o.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            try {
                methods[i].setAccessible(true);
                return methods[i].invoke(o, params);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
            catch (InvocationTargetException ite) {
                return null;
            }
        }
        return null;
    }

    public static List<Field> getClassHierarchyFields(Class clazz, Class fieldType, boolean isStatic, String[] fieldsToIgnore) {
        ArrayList<Field> results = new ArrayList<Field>();
        if (clazz == null) {
            return results;
        }
        if (clazz.equals(Object.class)) {
            return results;
        }
        List<Field> superClassFields = ReflectionUtils.getClassHierarchyFields(clazz.getSuperclass(), fieldType, isStatic, fieldsToIgnore);
        results.addAll(superClassFields);
        List<Field> classFields = ReflectionUtils.getClassFields(clazz, fieldType, isStatic, fieldsToIgnore);
        results.addAll(classFields);
        return results;
    }

    public static List<Field> getClassFields(Class clazz, Class type, boolean isStatic, String[] fieldsToIgnore) {
        ArrayList<Field> results = new ArrayList<Field>();
        if (clazz == null) {
            return results;
        }
        if (clazz.isPrimitive()) {
            return results;
        }
        if (clazz.isAnnotation()) {
            return results;
        }
        if (clazz.isInterface()) {
            return results;
        }
        if (clazz.isEnum()) {
            return results;
        }
        Collection<Object> toIgnore = fieldsToIgnore != null ? Arrays.asList(fieldsToIgnore) : Collections.EMPTY_SET;
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (toIgnore.contains(field.getName()) || isStatic && !Modifier.isStatic(field.getModifiers()) || !isStatic && Modifier.isStatic(field.getModifiers()) || type != null && !field.getType().equals(type)) continue;
            results.add(field);
        }
        return results;
    }

    public static Class[] getClassHierarchyInterfaces(Class clazz) {
        int i;
        if (clazz == null) {
            return new Class[0];
        }
        if (clazz.equals(Object.class)) {
            return new Class[0];
        }
        ArrayList results = new ArrayList();
        Class<?>[] ifaces = clazz.getInterfaces();
        for (i = 0; i < ifaces.length; ++i) {
            if (results.contains(ifaces[i])) continue;
            results.add(ifaces[i]);
        }
        ifaces = ReflectionUtils.getClassHierarchyInterfaces(clazz.getSuperclass());
        for (i = 0; i < ifaces.length; ++i) {
            if (results.contains(ifaces[i])) continue;
            results.add(ifaces[i]);
        }
        int index = 0;
        Class[] array = new Class[results.size()];
        for (Class clazz2 : results) {
            array[index++] = clazz2;
        }
        return array;
    }

    public static final String getGetMethodName(String fieldName) {
        return PREFIX_GET + ReflectionUtils.getValidAccessorName(fieldName);
    }

    public static final String getSetMethodName(String fieldName) {
        return PREFIX_SET + ReflectionUtils.getValidAccessorName(fieldName);
    }

    private static String getValidAccessorName(String fieldName) {
        char firstChar = fieldName.charAt(0);
        String field = StringUtil.toJavaClassName(fieldName);
        if (fieldName.length() > 1) {
            char secondChar = fieldName.charAt(1);
            if (Character.isLowerCase(firstChar) && Character.isUpperCase(secondChar)) {
                field = field.replaceFirst(Character.toString(field.charAt(0)), Character.toString(firstChar));
            }
        }
        return field;
    }

    public static final boolean isSetMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith(PREFIX_SET)) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class;
    }

    public static final boolean isGetMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith(PREFIX_GET)) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType() != null;
    }

    public static final boolean isIsMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith(PREFIX_IS)) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (method.getReturnType().isPrimitive() && method.getReturnType() != Boolean.TYPE) {
            return false;
        }
        return method.getReturnType().isPrimitive() || method.getReturnType() == Boolean.class;
    }

    public static void main(String[] args) {
        String s = new String("pepe");
        Object v1 = ReflectionUtils.getPrivateField(s, "cunt");
        Object v2 = ReflectionUtils.invokePrivateMethod(s, "sustring", new Object[]{new Integer(1)});
        System.out.println(v1);
        System.out.println(v2);
    }
}

