/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.CacheConfigurationGenerator;
import org.jboss.dashboard.database.cache.CacheOptions;
import org.jboss.dashboard.factory.BasicFactoryElement;

public class CacheConfigurationManager
extends BasicFactoryElement {
    private static transient Log log = LogFactory.getLog((String)CacheConfigurationManager.class.getName());
    private Properties cacheConfigurationGenerators = new Properties();
    private Properties hibernateProperties;
    private CacheOptions cacheOptions;
    private CacheConfigurationGenerator configGenerator;

    public CacheConfigurationGenerator getConfigGenerator() {
        return this.configGenerator;
    }

    public void setConfigGenerator(CacheConfigurationGenerator configGenerator) {
        this.configGenerator = configGenerator;
    }

    public Properties getCacheConfigurationGenerators() {
        return this.cacheConfigurationGenerators;
    }

    public void setCacheConfigurationGenerators(Properties cacheConfigurationGenerators) {
        this.cacheConfigurationGenerators = cacheConfigurationGenerators;
    }

    public CacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    public void setCacheOptions(CacheOptions cacheOptions) {
        this.cacheOptions = cacheOptions;
    }

    public Properties getHibernateProperties() {
        return this.hibernateProperties;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public void initializeCaches() {
        String use2ndLevelCache = this.hibernateProperties.getProperty("hibernate.cache.use_second_level_cache");
        if ("true".equals(use2ndLevelCache)) {
            String cacheProviderFullName = this.hibernateProperties.getProperty("hibernate.cache.provider_class", this.hibernateProperties.getProperty("hibernate.cache.region.factory_class"));
            if (!StringUtils.isEmpty((String)cacheProviderFullName)) {
                int lastDot = cacheProviderFullName.lastIndexOf(46);
                if (lastDot > 0) {
                    String providerName = cacheProviderFullName.substring(lastDot + 1);
                    String cacheGeneratorPath = this.cacheConfigurationGenerators.getProperty(providerName);
                    if (StringUtils.isEmpty((String)cacheGeneratorPath)) {
                        log.warn((Object)("No cache config generator for " + providerName));
                    } else {
                        this.configGenerator = (CacheConfigurationGenerator)this.factoryLookup(cacheGeneratorPath);
                        this.configGenerator.initializeCacheConfig(this);
                    }
                }
            } else {
                log.warn((Object)"Second level cache activated but no hibernate.cache.provider_class or hibernate.cache.region.factory_class parameter specified.");
            }
        }
    }

    public boolean createCustomCacheRegion(String cacheRegionName) {
        return this.configGenerator != null && this.configGenerator.createCustomCacheRegion(cacheRegionName);
    }

    public boolean freeAllCache() {
        return this.configGenerator.freeAllCache();
    }
}

