/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache.custom;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.custom.CacheMonitor;
import org.jboss.dashboard.database.cache.custom.CacheStatistics;
import org.jboss.dashboard.database.cache.custom.StatisticsObjectCache;

public class AutoCache
implements StatisticsObjectCache {
    Log log = LogFactory.getLog(this.getClass());
    private String type;
    private Map cache = Collections.synchronizedMap(new ReferenceMap());
    private CacheMonitor cacheMonitor;

    public AutoCache(boolean monitorizeCaches) {
        if (monitorizeCaches) {
            this.cacheMonitor = new CacheMonitor(Long.MAX_VALUE);
        }
    }

    @Override
    public void setType(String cacheType) {
        if (this.log.isDebugEnabled() && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache type set to '" + cacheType + "'."));
        }
        this.type = cacheType;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void put(Serializable key, Object object) {
        this.cache.put(key, object);
        if (this.cacheMonitor != null) {
            this.cacheMonitor.elementAdded();
        }
        if (this.log.isDebugEnabled() && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Put " + this.type + " #" + key + " in to cache."));
        }
    }

    @Override
    public Object get(Serializable key) {
        Object object = this.cache.get(key);
        if (object != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got " + this.type + " #" + key + " from cache."));
        }
        if (this.cacheMonitor != null) {
            if (object != null) {
                this.cacheMonitor.registerCacheHit();
            } else {
                this.cacheMonitor.registerCacheMiss();
            }
        }
        return object;
    }

    @Override
    public Object clear(Serializable key) {
        Object o;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cleared " + this.type + " #" + key + " from cache."));
        }
        if ((o = this.cache.remove(key)) != null && this.cacheMonitor != null) {
            this.cacheMonitor.elementEvicted();
        }
        return o;
    }

    @Override
    public void clearAll() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cleared entire " + this.type + " cache."));
        }
        this.cache = Collections.synchronizedMap(new ReferenceMap());
        if (this.cacheMonitor != null) {
            this.cacheMonitor.allElementsEvicted();
        }
    }

    @Override
    public CacheStatistics getCacheStatistics() {
        if (this.cacheMonitor != null) {
            return this.cacheMonitor.getCacheStatistics();
        }
        return null;
    }
}

