/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache.custom;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.CacheElement;
import org.jboss.dashboard.database.cache.CacheOptions;
import org.jboss.dashboard.database.cache.custom.AutoCache;
import org.jboss.dashboard.database.cache.custom.CacheStatistics;
import org.jboss.dashboard.database.cache.custom.FIFOCache;
import org.jboss.dashboard.database.cache.custom.HybridCache;
import org.jboss.dashboard.database.cache.custom.LRUCache;
import org.jboss.dashboard.database.cache.custom.MultiCache;
import org.jboss.dashboard.database.cache.custom.MultiCacheManager;
import org.jboss.dashboard.database.cache.custom.ObjectCache;
import org.jboss.dashboard.database.cache.custom.StatisticsObjectCache;
import org.jboss.dashboard.database.cache.custom.TimerCache;
import org.jboss.dashboard.factory.BasicFactoryElement;

public class CacheFactory
extends BasicFactoryElement {
    Log log = LogFactory.getLog(this.getClass());
    public CacheOptions cacheOptions;
    public MultiCacheManager multiCacheManager;
    private Set<String> customCaches = new TreeSet<String>();
    private boolean monitorizeCaches = true;
    private List<StatisticsObjectCache> createdCaches = new ArrayList<StatisticsObjectCache>();
    public static final String TYPE_LRU = "LRU";
    public static final String TYPE_AUTO = "Auto";
    public static final String TYPE_TIMER = "Timer";
    public static final String TYPE_HYBRID = "Hybrid";
    public static final String TYPE_FIFO = "FIFO";

    public boolean isMonitorizeCaches() {
        return this.monitorizeCaches;
    }

    public void setMonitorizeCaches(boolean monitorizeCaches) {
        this.monitorizeCaches = monitorizeCaches;
    }

    public ObjectCache createCache(String name) {
        ObjectCache cache = null;
        MultiCache multi = null;
        if (this.multiCacheManager.containsCache(name)) {
            this.log.error((Object)("Cache of type [" + name + "] already exists."));
        } else {
            CacheElement element = null;
            element = this.customCaches.contains(name) ? this.cacheOptions.getDefaultCacheElement() : this.cacheOptions.getElement(name);
            if (element == null) {
                element = this.cacheOptions.getDefaultCacheElement();
            }
            try {
                cache = this.createObjectCache(element, name);
                multi = new MultiCache(cache, this.multiCacheManager);
                this.multiCacheManager.addCache(multi);
            }
            catch (Exception e) {
                this.log.error((Object)"Problem instantiating cache:", (Throwable)e);
            }
        }
        return multi;
    }

    public ObjectCache createObjectCache(CacheElement element, String name) throws Exception {
        StatisticsObjectCache cache;
        if (TYPE_LRU.equals(element.getMemoryStoreEvictionPolicy())) {
            cache = new LRUCache(this.isMonitorizeCaches(), element.getMaxElementsInMemory());
        } else if (TYPE_AUTO.equals(element.getMemoryStoreEvictionPolicy())) {
            cache = new AutoCache(this.isMonitorizeCaches());
        } else if (TYPE_TIMER.equals(element.getMemoryStoreEvictionPolicy())) {
            cache = new TimerCache(this.isMonitorizeCaches(), element.getTimeToLiveSeconds() * 1000L, element.getMaxElementsInMemory());
        } else if (TYPE_HYBRID.equals(element.getMemoryStoreEvictionPolicy())) {
            cache = new HybridCache(this.isMonitorizeCaches(), element.getMaxElementsInMemory());
        } else if (TYPE_FIFO.equals(element.getMemoryStoreEvictionPolicy())) {
            cache = new FIFOCache(this.isMonitorizeCaches(), element.getMaxElementsInMemory());
        } else {
            this.log.warn((Object)("Unknown cache type: " + element.getMemoryStoreEvictionPolicy() + ". Defaulting to HybridCache."));
            cache = new HybridCache(this.isMonitorizeCaches(), element.getMaxElementsInMemory());
        }
        cache.setType(name);
        this.createdCaches.add(cache);
        return cache;
    }

    public Map<String, CacheStatistics> getCacheStatistics() {
        TreeMap<String, CacheStatistics> m = new TreeMap<String, CacheStatistics>();
        for (StatisticsObjectCache cache : this.createdCaches) {
            CacheStatistics statistics = cache.getCacheStatistics();
            if (statistics == null) continue;
            m.put(cache.getType(), statistics);
        }
        return m;
    }

    public void createCustomCache(String cacheRegionName) {
        this.customCaches.add(cacheRegionName);
    }

    public void printStatistics(PrintStream out, String separator) {
        Map<String, CacheStatistics> stats = this.getCacheStatistics();
        Set<String> keys = stats.keySet();
        out.print("cacheName");
        out.print(separator);
        out.print("numOperations");
        out.print(separator);
        out.print("averageOccupation");
        out.print(separator);
        out.print("averageOccupationRate");
        out.print(separator);
        out.print("cacheSize");
        out.print(separator);
        out.print("hitRate");
        out.print(separator);
        out.print("numReads");
        out.println("");
        for (String cacheName : keys) {
            CacheStatistics cacheStats = stats.get(cacheName);
            out.print(cacheName);
            out.print(separator);
            out.print(cacheStats.getNumOperations());
            out.print(separator);
            out.print(cacheStats.getAverageOccupation());
            out.print(separator);
            out.print(cacheStats.getAverageOccupationRate());
            out.print(separator);
            out.print(cacheStats.getCacheSize());
            out.print(separator);
            out.print(cacheStats.getHitRate());
            out.print(separator);
            out.print(cacheStats.getNumReads());
            out.println("");
        }
    }
}

