/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache.custom;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.custom.AutoCache;
import org.jboss.dashboard.database.cache.custom.CacheMonitor;
import org.jboss.dashboard.database.cache.custom.CacheStatistics;
import org.jboss.dashboard.database.cache.custom.LRUCache;
import org.jboss.dashboard.database.cache.custom.LRUCacheListener;
import org.jboss.dashboard.database.cache.custom.StatisticsObjectCache;

public class HybridCache
implements StatisticsObjectCache,
LRUCacheListener {
    Log log = LogFactory.getLog(this.getClass());
    private String type;
    private LRUCache lruCache;
    private AutoCache autoCache;
    private CacheMonitor cacheMonitor;

    public HybridCache(boolean monitorizeCaches, int size) {
        this.lruCache = new LRUCache(false, size);
        this.autoCache = new AutoCache(false);
        this.lruCache.setListener(this);
        if (monitorizeCaches) {
            this.cacheMonitor = new CacheMonitor(size);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache type set to '" + type + "'."));
        }
        this.type = type;
        this.lruCache.setType(type);
        this.autoCache.setType(type);
    }

    @Override
    public void objectRemoved(Serializable key, Object value) {
        this.autoCache.put(key, value);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Moved " + this.type + " #" + key + " to the auto cache."));
        }
        if (this.cacheMonitor != null) {
            this.cacheMonitor.elementEvicted();
        }
    }

    @Override
    public void put(Serializable key, Object object) {
        this.lruCache.put(key, object);
        if (this.cacheMonitor != null) {
            this.cacheMonitor.elementAdded();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Put " + this.type + " #" + key + " in to cache."));
        }
    }

    @Override
    public Object get(Serializable key) {
        Object object = this.lruCache.get(key);
        if (object != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Got " + this.type + " #" + key + " from LRU cache."));
            }
        } else {
            object = this.autoCache.get(key);
            if (object != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Got " + this.type + " #" + key + " from auto cache."));
                }
                this.lruCache.put(key, object);
                this.autoCache.clear(key);
            }
        }
        if (this.cacheMonitor != null) {
            if (object != null) {
                this.cacheMonitor.registerCacheHit();
            } else {
                this.cacheMonitor.registerCacheMiss();
            }
        }
        return object;
    }

    @Override
    public Object clear(Serializable key) {
        Object o;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cleared " + this.type + " #" + key + " from cache."));
        }
        if ((o = this.lruCache.clear(key)) == null && (o = this.autoCache.clear(key)) != null && this.cacheMonitor != null) {
            this.cacheMonitor.elementEvicted();
        }
        return o;
    }

    @Override
    public void clearAll() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cleared entire " + this.type + " cache."));
        }
        this.lruCache.clearAll();
        this.autoCache.clearAll();
        if (this.cacheMonitor != null) {
            this.cacheMonitor.allElementsEvicted();
        }
    }

    @Override
    public CacheStatistics getCacheStatistics() {
        if (this.cacheMonitor != null) {
            return this.cacheMonitor.getCacheStatistics();
        }
        return null;
    }
}

