/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache.custom;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.custom.CacheMonitor;
import org.jboss.dashboard.database.cache.custom.CacheStatistics;
import org.jboss.dashboard.database.cache.custom.LRUCacheListener;
import org.jboss.dashboard.database.cache.custom.StatisticsObjectCache;
import org.jboss.dashboard.database.cache.custom.map.SynchronizedLRUMap;

public class LRUCache
implements StatisticsObjectCache {
    Log log = LogFactory.getLog(this.getClass());
    private CacheMonitor cacheMonitor;
    private String type;
    private int size;
    private ListeningLRUMap cache;

    public LRUCache(boolean monitorizeCaches, int size) {
        this.cache = new ListeningLRUMap(size);
        if (monitorizeCaches) {
            this.cacheMonitor = new CacheMonitor(size);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache type set to '" + type + "'."));
        }
        this.type = type;
    }

    @Override
    public void put(Serializable key, Object object) {
        this.cache.put(key, object);
        if (this.cacheMonitor != null) {
            this.cacheMonitor.elementAdded();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Put " + this.type + " #" + key + " in to cache."));
        }
    }

    @Override
    public Object get(Serializable key) {
        Object object = this.cache.get(key);
        if (object != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got " + this.type + " #" + key + " from cache."));
        }
        if (this.cacheMonitor != null) {
            if (object != null) {
                this.cacheMonitor.registerCacheHit();
            } else {
                this.cacheMonitor.registerCacheMiss();
            }
        }
        return object;
    }

    @Override
    public Object clear(Serializable key) {
        Object o;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cleared " + this.type + " #" + key + " from cache."));
        }
        if ((o = this.cache.remove(key)) != null && this.cacheMonitor != null) {
            this.cacheMonitor.elementEvicted();
        }
        return o;
    }

    @Override
    public void clearAll() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cleared entire " + this.type + " cache."));
        }
        this.cache.clear();
        if (this.cacheMonitor != null) {
            this.cacheMonitor.allElementsEvicted();
        }
    }

    public void setListener(LRUCacheListener l) {
        this.cache.setListener(l);
    }

    @Override
    public CacheStatistics getCacheStatistics() {
        if (this.cacheMonitor != null) {
            return this.cacheMonitor.getCacheStatistics();
        }
        return null;
    }

    public class ListeningLRUMap
    extends SynchronizedLRUMap {
        private LRUCacheListener listener;

        public ListeningLRUMap(int size) {
            super(size);
            this.listener = null;
        }

        public void setListener(LRUCacheListener l) {
            this.listener = l;
        }

        protected void processRemovedLRU(Object key, Object value) {
            if (this.listener != null) {
                this.listener.objectRemoved((Serializable)key, value);
            }
        }
    }
}

