/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.custom.CacheNotification;
import org.jboss.dashboard.database.cache.custom.MultiCache;
import org.jboss.dashboard.factory.BasicFactoryElement;

public class MultiCacheManager
extends BasicFactoryElement {
    private static transient Log log = LogFactory.getLog((String)MultiCacheManager.class.getName());
    protected static Map instances = new HashMap();
    public boolean groupClears = true;
    public long clearIntervalMillis = 1000L;
    private List<CacheNotification> cacheNotifications = new ArrayList<CacheNotification>();
    private boolean shuttingDown = false;
    private HashMap<String, MultiCache> caches = new HashMap();

    public void addCache(MultiCache cache) {
        this.caches.put(cache.getType(), cache);
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.groupClears) {
            Runnable sendClears = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        try {
                            Thread.sleep(MultiCacheManager.this.clearIntervalMillis);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)"Error: ", (Throwable)e);
                        }
                        List list = MultiCacheManager.this.cacheNotifications;
                        synchronized (list) {
                            if (!MultiCacheManager.this.cacheNotifications.isEmpty()) {
                                if (log.isDebugEnabled()) {
                                    log.warn((Object)("Sending " + MultiCacheManager.this.cacheNotifications.size() + " cache clears."));
                                }
                                MultiCacheManager.this.cacheNotifications.clear();
                            }
                        }
                    } while (!MultiCacheManager.this.shuttingDown);
                    MultiCacheManager.this.cacheNotifications = null;
                }
            };
            Thread tflusher = new Thread(sendClears, "Cache clears flusher. Flushes cache invalidation messages.");
            tflusher.setPriority(1);
            tflusher.setDaemon(false);
            tflusher.start();
        }
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.shuttingDown = true;
    }

    public boolean containsCache(String type) {
        return this.caches.containsKey(type);
    }

    public void clearAllCaches() {
        for (MultiCache cache : this.caches.values()) {
            cache.doClearAll();
        }
    }
}

