/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache.custom;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.database.cache.custom.CacheMonitor;
import org.jboss.dashboard.database.cache.custom.CacheStatistics;
import org.jboss.dashboard.database.cache.custom.StatisticsObjectCache;
import org.jboss.dashboard.database.cache.custom.map.SynchronizedLRUMap;

public class TimerCache
implements StatisticsObjectCache,
Runnable {
    private CacheMonitor cacheMonitor;
    private static final Log log = LogFactory.getLog(TimerCache.class);
    private String type;
    private long deadline = Long.MAX_VALUE;
    private boolean running = true;
    private Thread thread;
    private long timeout;
    private final SynchronizedLRUMap cache;

    public TimerCache(boolean monitorizeCaches, long timeout, int size) {
        this.timeout = timeout;
        this.cache = new SynchronizedLRUMap(size);
        this.thread = new Thread(this);
        this.thread.start();
        if (monitorizeCaches) {
            this.cacheMonitor = new CacheMonitor(size);
        }
    }

    public void setTimeout(long newTimeout) {
        this.timeout = newTimeout;
    }

    public synchronized void stop() {
        this.running = false;
        this.notify();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache type set to '" + type + "'."));
        }
        this.type = type;
        this.thread.setName("TimerCache-" + type);
    }

    @Override
    public void put(Serializable key, Object object) {
        if (key == null) {
            log.error((Object)"Trying to put object in cache with null key. Ignoring");
            return;
        }
        if (object == null) {
            this.clear(key);
        } else {
            TStampObject tobj = new TStampObject();
            tobj.object = object;
            tobj.time = System.currentTimeMillis() + this.timeout;
            this.cache.put(key, tobj);
            this.setDeadline(tobj.time);
            if (this.cacheMonitor != null) {
                this.cacheMonitor.elementAdded();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Put " + this.type + " #" + key + " in to cache."));
            }
        }
    }

    @Override
    public Object get(Serializable key) {
        if (key == null) {
            return null;
        }
        TStampObject tobj = (TStampObject)this.cache.get(key);
        Object object = null;
        if (tobj != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got " + this.type + " #" + key + " from cache."));
            }
            object = tobj.object;
        }
        if (this.cacheMonitor != null) {
            if (object != null) {
                this.cacheMonitor.registerCacheHit();
            } else {
                this.cacheMonitor.registerCacheMiss();
            }
        }
        return object;
    }

    @Override
    public Object clear(Serializable key) {
        Object o;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cleared " + this.type + " #" + key + " from cache."));
        }
        if ((o = this.cache.remove(key)) != null && this.cacheMonitor != null) {
            this.cacheMonitor.elementEvicted();
        }
        return o;
    }

    @Override
    public void clearAll() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cleared entire " + this.type + " cache."));
        }
        this.cache.clear();
        if (this.cacheMonitor != null) {
            this.cacheMonitor.allElementsEvicted();
        }
    }

    protected synchronized void setDeadline(long time) {
        if (time < this.deadline) {
            this.deadline = time;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            Object object;
            try {
                object = this;
                synchronized (object) {
                    long now = System.currentTimeMillis();
                    long waitTime = this.deadline - now;
                    if (waitTime > 0L) {
                        this.wait(waitTime);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            object = this.cache;
            synchronized (object) {
                this.trimQueue(this.cache);
            }
        }
    }

    protected void trimQueue(SynchronizedLRUMap cache) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Waking up.");
        }
        if (cache.isEmpty()) {
            return;
        }
        Object key = cache.firstKey();
        TStampObject tobj = (TStampObject)cache.get(key);
        if (tobj != null) {
            long now = System.currentTimeMillis();
            while (tobj != null && tobj.time <= now) {
                cache.remove(key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Timed out object with key '" + key + "'."));
                }
                if (cache.isEmpty()) {
                    key = null;
                    tobj = null;
                    continue;
                }
                key = cache.firstKey();
                tobj = (TStampObject)cache.get(key);
            }
        }
        this.deadline = tobj != null ? tobj.time : Long.MAX_VALUE;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sleeping.");
        }
    }

    @Override
    public CacheStatistics getCacheStatistics() {
        if (this.cacheMonitor != null) {
            return this.cacheMonitor.getCacheStatistics();
        }
        return null;
    }

    static class TStampObject {
        public long time;
        public Object object;

        TStampObject() {
        }
    }
}

