/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.cache.providers;

import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.jboss.dashboard.database.cache.custom.CacheFactory;
import org.jboss.dashboard.database.cache.custom.CustomCache;
import org.jboss.dashboard.database.cache.custom.ObjectCache;
import org.jboss.dashboard.factory.Factory;

public class CustomCacheProvider
implements CacheProvider {
    private CacheFactory factory;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        ObjectCache cache = this.factory.createCache(regionName);
        if (cache == null) {
            throw new CacheException("CustomCache did not create a cache: " + regionName);
        }
        return new CustomCache(cache, regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) throws CacheException {
        this.factory = (CacheFactory)Factory.lookup("org.jboss.dashboard.database.cache.custom.CacheFactory");
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }
}

