/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.lob.BlobImpl;
import org.hibernate.usertype.UserType;
import org.jboss.dashboard.database.hibernate.LOBHelper;

public class BinaryBlobType
extends BlobImpl
implements UserType,
Serializable {
    private static transient Log log = LogFactory.getLog((String)BinaryBlobType.class.getName());

    public BinaryBlobType(InputStream inputStream, int i) {
        super(inputStream, i);
    }

    public BinaryBlobType(byte[] bytes) {
        super(bytes);
    }

    public BinaryBlobType() {
        super(new byte[0]);
    }

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public int hashCode(Object o) throws HibernateException {
        return o == null ? 0 : o.hashCode();
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        LOBHelper.lookup().nullSafeSet(st, value, index, new LOBHelper.ValueWriter(){

            @Override
            public void writeValue(OutputStream os, Object value) throws IOException {
                if (value != null) {
                    os.write((byte[])value);
                }
            }

            @Override
            public void writeValue(PreparedStatement st, Object value, int index) throws SQLException {
                st.setBytes(index, (byte[])value);
            }
        });
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Object o;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting value with names " + Arrays.asList(names)));
        }
        if ((o = rs.getObject(names[0])) == null) {
            return null;
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            if (blob == null) {
                return null;
            }
            return blob.getBytes(1L, (int)blob.length());
        }
        if (o instanceof byte[]) {
            return o;
        }
        throw new IllegalArgumentException("Unexpected value read. Must be Blob or byte[], but it is " + o.getClass());
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object o) throws HibernateException {
        if (o == null) {
            return null;
        }
        byte[] b = (byte[])o;
        return b;
    }

    public Object assemble(Serializable serializable, Object owner) throws HibernateException {
        if (serializable == null) {
            return null;
        }
        return (byte[])serializable;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        if (original == null) {
            return null;
        }
        byte[] copy = new byte[((byte[])original).length];
        System.arraycopy((byte[])original, 0, copy, 0, copy.length);
        return copy;
    }
}

