/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.hibernate;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.database.hibernate.HibernateSessionFactoryProvider;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.jboss.dashboard.database.hibernate.HibernateWork;
import org.jboss.dashboard.error.ErrorManager;
import org.jboss.dashboard.factory.Factory;
import org.jboss.dashboard.factory.FactoryWork;

public class HibernateTransaction {
    private static transient Log log = LogFactory.getLog((String)HibernateTransaction.class.getName());
    private static transient ThreadLocal<HibernateTransaction> activeTx = new ThreadLocal();
    private String id = Thread.currentThread().getName();
    HibernateTxFragment currentFragment = null;
    List<HibernateTxFragment> listeners;
    List<HibernateTxFragment> followers = new ArrayList<HibernateTxFragment>();
    private Session session = null;
    private boolean active = false;
    private boolean rollback = false;
    private boolean completing = false;

    public static HibernateTransaction getCurrentTx() {
        HibernateTransaction tx = activeTx.get();
        if (tx == null) {
            tx = new HibernateTransaction();
            activeTx.set(tx);
        }
        return tx;
    }

    private HibernateTransaction() {
        this.listeners = new ArrayList<HibernateTxFragment>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public void setRollback(boolean rollback) {
        this.rollback = rollback;
    }

    public boolean isActive() {
        return this.active;
    }

    public void begin() throws Exception {
        log.debug((Object)("Begin transaction. Id=" + this.getId()));
        HibernateSessionFactoryProvider hibernateSessionFactoryProvider = CoreServices.lookup().getHibernateSessionFactoryProvider();
        SessionFactory sessionFactory = hibernateSessionFactoryProvider.getSessionFactory();
        this.session = sessionFactory.openSession();
        this.session.getTransaction().begin();
        this.active = true;
    }

    public void complete() {
        if (!this.rollback) {
            this.flush();
        }
        this.completing = true;
        this.notifyListeners(true);
        if (this.rollback) {
            this.rollback();
        } else {
            this.commit();
        }
        this.completing = false;
        this.active = false;
        this.close();
        activeTx.set(null);
        this.notifyListeners(false);
        this.processFollowers();
    }

    protected void flush() {
        try {
            log.debug((Object)("Flush transaction. Id=" + this.getId()));
            this.session.flush();
        }
        catch (Throwable e) {
            log.debug((Object)("Flush error. Id=" + this.getId()));
            this.error(e);
        }
    }

    protected void close() {
        try {
            log.debug((Object)("Close transaction. Id=" + this.getId()));
            this.session.close();
        }
        catch (Throwable e) {
            log.error((Object)("Close error. Id=" + this.getId()));
            this.error(e);
        }
    }

    protected void rollback() {
        try {
            log.debug((Object)("Rollback transaction. Id=" + this.getId()));
            this.session.getTransaction().rollback();
        }
        catch (Throwable e) {
            log.error((Object)("Error in rollback. Id=" + this.getId()));
            this.rollback = false;
            this.error(e);
        }
    }

    protected void commit() {
        try {
            log.debug((Object)("Commit transaction. Id=" + this.getId()));
            this.session.getTransaction().commit();
        }
        catch (Throwable e) {
            log.error((Object)("Error in commit. Id=" + this.getId()));
            this.error(e);
        }
    }

    public void error(Throwable t) {
        if (!this.rollback) {
            this.rollback = true;
            ErrorManager.lookup().notifyError(t, true);
        }
    }

    protected final void executeFragment(HibernateTxFragment fragment) throws Exception {
        FlushMode flushMode = this.session.getFlushMode();
        boolean flushChanged = false;
        try {
            fragment.parentFragment = this.currentFragment;
            this.currentFragment = fragment;
            HibernateTxFragment flusherFragment = this.getFlusherFragment();
            if (fragment == flusherFragment) {
                this.session.setFlushMode(FlushMode.COMMIT);
                flushChanged = true;
            }
            fragment.txFragment(this.session);
            if (fragment == flusherFragment) {
                log.debug((Object)("Flush transaction. Id=" + this.getId()));
                this.session.flush();
            }
        }
        catch (Throwable t) {
            this.error(t);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
        finally {
            if (flushChanged) {
                this.session.setFlushMode(flushMode);
            }
            this.currentFragment = fragment.parentFragment;
            if (fragment.callbacksEnabled) {
                this.listeners.add(fragment);
                if (this.completing) {
                    this.notifyListener(true, fragment);
                }
            }
        }
    }

    protected HibernateTxFragment getFlusherFragment() {
        HibernateTxFragment setter = null;
        HibernateTxFragment fragment = this.currentFragment;
        while (fragment != null) {
            if (fragment.flushAfterFinish) {
                setter = fragment;
            }
            fragment = fragment.parentFragment;
        }
        return setter;
    }

    protected void notifyListeners(boolean before) {
        if (!this.listeners.isEmpty()) {
            log.debug((Object)((before ? "Before " : "After ") + (this.rollback ? "rollback" : "commit")));
        }
        for (HibernateTxFragment listener : new ArrayList<HibernateTxFragment>(this.listeners)) {
            boolean wasCommit = !this.rollback;
            this.notifyListener(before, listener);
            if (!before || !wasCommit || !this.rollback) continue;
            this.notifyListeners(true);
            break;
        }
    }

    protected void notifyListener(boolean before, HibernateTxFragment listener) {
        if (before) {
            if (this.rollback) {
                this.notifyBeforeRollback(listener);
            } else {
                this.notifyBeforeCommit(listener);
            }
        } else if (this.rollback) {
            this.notifyAfterRollback(listener);
        } else {
            this.notifyAfterCommit(listener);
        }
    }

    private void processFollowers() {
        for (HibernateTxFragment fragment : this.followers) {
            try {
                log.debug((Object)"Follower");
                fragment.execute();
            }
            catch (Throwable e) {
                log.error((Object)("Follower error. Id=" + this.getId()), e);
            }
        }
    }

    protected void notifyBeforeCommit(HibernateTxFragment fragment) {
        try {
            fragment.beforeCommit();
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    protected void notifyBeforeRollback(HibernateTxFragment fragment) {
        try {
            fragment.beforeRollback();
        }
        catch (Throwable e) {
            log.error((Object)"Error before rollback: ", e);
        }
    }

    protected void notifyAfterCommit(HibernateTxFragment fragment) {
        try {
            fragment.afterCommit();
        }
        catch (Throwable e) {
            log.error((Object)"Error after commit: ", e);
        }
    }

    protected void notifyAfterRollback(HibernateTxFragment fragment) {
        try {
            fragment.afterRollback();
        }
        catch (Throwable e) {
            log.error((Object)"Error after rollback: ", e);
        }
    }

    public static Object runWork(final HibernateWork work) throws Throwable {
        final Throwable[] error = new Throwable[]{null};
        final Object[] result = new Object[]{null};
        Factory.doWork(new FactoryWork(){

            @Override
            public void doWork() {
                try {
                    new HibernateTxFragment(){

                        @Override
                        protected void txFragment(Session session) throws Throwable {
                            result[0] = work.doWork(session);
                        }
                    }.execute();
                }
                catch (Throwable e) {
                    error[0] = e;
                }
            }
        });
        if (error[0] != null) {
            throw error[0];
        }
        return result[0];
    }
}

