/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.annotation.Priority;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.database.InstalledModule;
import org.jboss.dashboard.database.hibernate.HibernateInitializer;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.jboss.dashboard.factory.InitialModule;
import org.jboss.dashboard.factory.InitialModuleRegistry;

@ApplicationScoped
public class InitialModulesManager
implements Startable {
    public static transient Log log = LogFactory.getLog((String)InitialModulesManager.class.getName());
    @Inject
    private InitialModuleRegistry initialModuleRegistry;
    @Inject
    @Config(value="false")
    private boolean clearCachesAfterLoading;

    @Override
    public Priority getPriority() {
        return Priority.LOW;
    }

    @Override
    public void start() throws Exception {
        List<InitialModule> modules = this.initialModuleRegistry.getInitialModulesRegistered();
        for (final InitialModule module : modules) {
            new HibernateTxFragment(true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void txFragment(Session session) throws Exception {
                    InstalledModule currentVersion = InitialModulesManager.this.loadAndLockModule(module.getName());
                    if (currentVersion != null) {
                        try {
                            if (currentVersion.getVersion() == module.getVersion()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Module " + module.getName() + " version " + module.getVersion() + "is already installed."));
                                }
                            } else if (currentVersion.getVersion() == 0L) {
                                if (module.doTheInstall()) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Installed module " + module.getName() + " version " + module.getVersion()));
                                    }
                                    InitialModulesManager.this.storeModule(currentVersion, module);
                                } else {
                                    log.warn((Object)("Error installing module " + module.getName() + " version " + module.getVersion()));
                                }
                            } else if (module.doTheUpgrade(currentVersion.getVersion())) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Upgraded module " + module.getName() + " to version " + module.getVersion()));
                                }
                                InitialModulesManager.this.storeModule(currentVersion, module);
                            } else {
                                log.warn((Object)("Error upgrading module " + module.getName() + " to version " + module.getVersion()));
                            }
                        }
                        finally {
                            InitialModulesManager.this.unlockModule(currentVersion);
                        }
                    }
                }
            }.execute();
        }
        if (this.clearCachesAfterLoading) {
            HibernateInitializer hin = CoreServices.lookup().getHibernateInitializer();
            hin.evictAllCaches();
        }
    }

    protected void unlockModule(final InstalledModule currentVersion) throws Exception {
        HibernateTxFragment fragment = new HibernateTxFragment(){

            @Override
            public void txFragment(Session session) throws Exception {
                currentVersion.setStatus(null);
                session.update((Object)currentVersion);
                session.flush();
            }
        };
        fragment.execute();
    }

    protected void storeModule(final InstalledModule currentVersion, final InitialModule newVersion) {
        try {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    currentVersion.setVersion(newVersion.getVersion());
                    session.saveOrUpdate((Object)currentVersion);
                    session.flush();
                }
            }.execute();
        }
        catch (Exception e) {
            log.error((Object)("Error saving InstalledModule " + newVersion.getName() + " version " + newVersion.getVersion()), (Throwable)e);
        }
    }

    protected InstalledModule loadAndLockModule(final String moduleName) {
        final InstalledModule[] module = new InstalledModule[1];
        try {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    InstalledModule currentVersion = (InstalledModule)session.get(InstalledModule.class, (Serializable)((Object)moduleName), LockMode.UPGRADE);
                    if (currentVersion == null) {
                        module[0] = new InstalledModule(moduleName, 0L);
                        module[0].setStatus("loading");
                        session.save((Object)module[0]);
                    } else if (StringUtils.isEmpty((String)currentVersion.getStatus())) {
                        currentVersion.setStatus("loading");
                        session.update((Object)currentVersion);
                        module[0] = currentVersion;
                    }
                    session.flush();
                }
            }.execute();
        }
        catch (Exception e) {
            log.error((Object)("Error loading InstalledModule " + moduleName), (Throwable)e);
        }
        return module[0];
    }
}

