/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jboss.dashboard.profiler.CodeBlockTraces;
import org.jboss.dashboard.profiler.CodeBlockType;
import org.jboss.dashboard.profiler.Profiler;
import org.jboss.dashboard.profiler.ThreadProfile;

public abstract class CodeBlockTrace {
    protected static DateFormat dateFormat = DateFormat.getDateTimeInstance();
    ThreadProfile threadProfile = null;
    protected CodeBlockTrace parent = null;
    protected CodeBlockTraces children;
    protected String id;
    protected long beginTimeMillis;
    protected long endTimeMillis;
    protected long childrenElapsedTimeMillis;
    protected Set<CodeBlockType> ancestorTypes;

    public CodeBlockTrace(String id) {
        this.id = id;
        this.beginTimeMillis = -1L;
        this.endTimeMillis = -1L;
        this.childrenElapsedTimeMillis = 0L;
        this.children = null;
        this.ancestorTypes = null;
    }

    public abstract CodeBlockType getType();

    public abstract String getDescription();

    public abstract Map<String, Object> getContext();

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).toHashCode();
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.id == null) {
                return false;
            }
            CodeBlockTrace other = (CodeBlockTrace)obj;
            return this.id.equals(other.id);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public ThreadProfile getThreadProfile() {
        return this.threadProfile;
    }

    public void setThreadProfile(ThreadProfile threadProfile) {
        this.threadProfile = threadProfile;
    }

    public CodeBlockTrace getParent() {
        return this.parent;
    }

    public void setParent(CodeBlockTrace parent) {
        this.parent = parent;
    }

    public CodeBlockTraces getChildren() {
        return this.children;
    }

    public void setChildren(CodeBlockTraces children) {
        this.children = children;
    }

    public Set<CodeBlockType> getAncestorTypes() {
        return this.ancestorTypes;
    }

    public void setAncestorTypes(Set<CodeBlockType> ancestorTypes) {
        this.ancestorTypes = ancestorTypes;
    }

    public boolean isDescendantOfType(CodeBlockType type) {
        return this.ancestorTypes != null && this.ancestorTypes.contains(type);
    }

    public void addChild(CodeBlockTrace child) {
        if (this.children != null && this.children.size() > 10000) {
            return;
        }
        HashSet<CodeBlockType> childAncestorTypes = new HashSet<CodeBlockType>();
        childAncestorTypes.add(this.getType());
        if (this.ancestorTypes != null) {
            childAncestorTypes.addAll(this.ancestorTypes);
        }
        child.setAncestorTypes(childAncestorTypes);
        child.setParent(this);
        if (this.children == null) {
            this.children = new CodeBlockTraces();
        }
        this.children.add(child);
    }

    public void removeChild(CodeBlockTrace child) {
        if (this.children != null) {
            child.setParent(null);
            this.children.remove(child);
        }
    }

    public CodeBlockTraces getDescendants() {
        if (this.children == null) {
            return null;
        }
        CodeBlockTraces result = new CodeBlockTraces();
        for (int i = 0; i < this.children.size(); ++i) {
            CodeBlockTrace child = this.children.get(i);
            CodeBlockTraces descendants = child.getDescendants();
            result.add(child);
            result.addAll(descendants);
        }
        return result;
    }

    public int getLevel() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getLevel() + 1;
    }

    public CodeBlockTraces toPlainList() {
        CodeBlockTraces results = new CodeBlockTraces();
        results.add(this);
        results.addAll(this.getDescendants());
        return results;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getBeginTimeMillis() {
        return this.beginTimeMillis;
    }

    public void setBeginTimeMillis(long beginTimeMillis) {
        this.beginTimeMillis = beginTimeMillis;
    }

    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public void setEndTimeMillis(long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
    }

    public long getElapsedTimeMillis() {
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.beginTimeMillis;
        }
        return this.endTimeMillis - this.beginTimeMillis;
    }

    public long getSelfTimeMillis() {
        if (this.isRunning()) {
            return 0L;
        }
        long total = this.getElapsedTimeMillis();
        long self = total - this.childrenElapsedTimeMillis;
        return self > 0L ? self : 0L;
    }

    public long getChildrenElapsedTimeMillis() {
        return this.childrenElapsedTimeMillis;
    }

    public boolean isRunning() {
        return this.endTimeMillis == -1L;
    }

    public CodeBlockTrace begin() {
        if (this.beginTimeMillis == -1L) {
            this.beginTimeMillis = System.currentTimeMillis();
            ThreadProfile threadExec = Profiler.lookup().getCurrentThreadProfile();
            if (threadExec != null) {
                this.threadProfile = threadExec;
                CodeBlockTrace currentTrace = threadExec.codeBlockInProgress;
                if (currentTrace != null) {
                    currentTrace.addChild(this);
                }
                threadExec.codeBlockInProgress = this;
                threadExec.addCodeBlockBeginEvent(this);
            }
        }
        return this;
    }

    public void end() {
        if (this.endTimeMillis == -1L) {
            ThreadProfile threadExec;
            this.endTimeMillis = System.currentTimeMillis();
            if (this.parent != null) {
                this.parent.childrenElapsedTimeMillis += this.getElapsedTimeMillis();
            }
            if ((threadExec = Profiler.lookup().getCurrentThreadProfile()) != null) {
                CodeBlockTrace runningParent = this.parent;
                while (runningParent != null && !runningParent.isRunning()) {
                    runningParent = runningParent.parent;
                }
                threadExec.codeBlockInProgress = runningParent;
                threadExec.addCodeBlockEndEvent(this);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getType().getId()).append("=").append(this.getDescription()).append("\n");
        if (this.beginTimeMillis > 0L) {
            buf.append("Begin date").append("=").append(dateFormat.format(new Date(this.getBeginTimeMillis()))).append("\n");
        }
        if (this.endTimeMillis > 0L) {
            buf.append("End date").append("=").append(dateFormat.format(new Date(this.getEndTimeMillis()))).append("\n");
        }
        buf.append(this.printContext(false, "=", "\n"));
        return buf.toString();
    }

    public String printContext(boolean includeParent) {
        return this.printContext(includeParent, "=", "\n", 0);
    }

    public String printContext(boolean includeParent, String valueSeparator, String rowSeparator) {
        return this.printContext(includeParent, valueSeparator, rowSeparator, 0);
    }

    public String printContext(boolean includeParent, String valueSeparator, String rowSeparator, int indent) {
        if (includeParent && this.parent != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.parent.printContext(true, valueSeparator, rowSeparator, indent));
            buf.append(rowSeparator);
            buf.append(this.printMap(this.getContext(), valueSeparator, rowSeparator, indent));
            return buf.toString();
        }
        return this.printMap(this.getContext(), valueSeparator, rowSeparator, indent);
    }

    public void printIndent(StringBuffer buf, int indent) {
        for (int i = 0; i < indent; ++i) {
            buf.append("    ");
        }
    }

    public String printMap(Map m, String valueSeparator, String rowSeparator) {
        return this.printMap(m, valueSeparator, rowSeparator, 0);
    }

    public String printMap(Map m, String valueSeparator, String rowSeparator, int indent) {
        StringBuffer buf = new StringBuffer();
        for (Object key : m.keySet()) {
            Object value = m.get(key);
            if (buf.length() > 0) {
                buf.append(rowSeparator);
            }
            this.printIndent(buf, indent);
            buf.append(key != null ? key.toString() : "null");
            buf.append(valueSeparator);
            buf.append(value != null ? value.toString() : "null");
        }
        return buf.toString();
    }
}

