/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.misc;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.jboss.dashboard.LocaleManager;
import org.jfree.data.time.Quarter;

public class CalendarUtils {
    public static Calendar getInstance() {
        return Calendar.getInstance(LocaleManager.currentLocale());
    }

    public static void main(String[] args) {
        Calendar c = Calendar.getInstance(new Locale("es"));
        System.out.println("\nLast hour: ");
        CalendarUtils.print(CalendarRangeUtils.getLastHour(c));
        System.out.println("\nLast 12 hours: ");
        CalendarUtils.print(CalendarRangeUtils.getLast12Hours(c));
        System.out.println("\ntoday: ");
        CalendarUtils.print(CalendarRangeUtils.getToday(c));
        System.out.println("\nyesterday: ");
        CalendarUtils.print(CalendarRangeUtils.getYesterday(c));
        System.out.println("\nLast 7days: ");
        CalendarUtils.print(CalendarRangeUtils.getLast7Days(c));
        System.out.println("\nthis month: ");
        CalendarUtils.print(CalendarRangeUtils.getThisMonth(c));
        System.out.println("\nlast month: ");
        CalendarUtils.print(CalendarRangeUtils.getLastMonth(c));
        System.out.println("\nThis quarter: ");
        CalendarUtils.print(CalendarRangeUtils.getThisQuarter(c));
        System.out.println("\nLast quarter: ");
        CalendarUtils.print(CalendarRangeUtils.getLastQuarter(c));
        System.out.println("\nLast 6 months: ");
        CalendarUtils.print(CalendarRangeUtils.getLast6Months(c));
        System.out.println("\nthis year: ");
        CalendarUtils.print(CalendarRangeUtils.getThisYear(c));
        System.out.println("\nlast year: ");
        CalendarUtils.print(CalendarRangeUtils.getLastYear(c));
    }

    protected static void print(Calendar[] calendar) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        System.out.print(" - FROM: " + sdf.format(calendar[0].getTime()) + " - TO: " + sdf.format(calendar[1].getTime()));
    }

    public static class CalendarRangeUtils {
        public static Calendar setAtDayStart(Calendar calendar) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            return calendar;
        }

        public static Calendar setAtDayEnd(Calendar calendar) {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            return calendar;
        }

        public static Calendar[] getLastHour(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            calendarFrom.add(10, -1);
            return new Calendar[]{calendarFrom, referenceCalendar};
        }

        public static Calendar[] getLast12Hours(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            calendarFrom.add(10, -12);
            return new Calendar[]{calendarFrom, referenceCalendar};
        }

        public static Calendar[] getToday(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            CalendarRangeUtils.setAtDayStart(calendarFrom);
            return new Calendar[]{calendarFrom, referenceCalendar};
        }

        public static Calendar[] getYesterday(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            calendarFrom.add(7, -1);
            CalendarRangeUtils.setAtDayStart(calendarFrom);
            Calendar calendarTo = (Calendar)referenceCalendar.clone();
            calendarTo.add(7, -1);
            CalendarRangeUtils.setAtDayEnd(calendarTo);
            return new Calendar[]{calendarFrom, calendarTo};
        }

        public static Calendar[] getLast7Days(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            calendarFrom.add(7, -7);
            CalendarRangeUtils.setAtDayStart(calendarFrom);
            return new Calendar[]{calendarFrom, referenceCalendar};
        }

        public static Calendar[] getThisMonth(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            calendarFrom.set(5, 1);
            CalendarRangeUtils.setAtDayStart(calendarFrom);
            return new Calendar[]{calendarFrom, referenceCalendar};
        }

        public static Calendar[] getLastMonth(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            calendarFrom.add(2, -1);
            calendarFrom.set(5, 1);
            CalendarRangeUtils.setAtDayStart(calendarFrom);
            Calendar calendarTo = (Calendar)referenceCalendar.clone();
            calendarTo.add(2, -1);
            calendarTo.set(5, calendarTo.getActualMaximum(5));
            CalendarRangeUtils.setAtDayEnd(calendarTo);
            return new Calendar[]{calendarFrom, calendarTo};
        }

        public static Calendar[] getThisQuarter(Calendar referenceCalendar) {
            Quarter quarter = new Quarter(referenceCalendar.getTime());
            Calendar startCal = CalendarUtils.getInstance();
            Calendar endCal = CalendarUtils.getInstance();
            long start = quarter.getFirstMillisecond(CalendarUtils.getInstance());
            long end = quarter.getLastMillisecond(CalendarUtils.getInstance());
            startCal.setTimeInMillis(start);
            endCal.setTimeInMillis(end);
            return new Calendar[]{startCal, endCal};
        }

        public static Calendar[] getLastQuarter(Calendar referenceCalendar) {
            Quarter quarter = new Quarter(referenceCalendar.getTime());
            Calendar startCal = CalendarUtils.getInstance();
            Calendar endCal = CalendarUtils.getInstance();
            long start = quarter.previous().getFirstMillisecond(CalendarUtils.getInstance());
            long end = quarter.previous().getLastMillisecond(CalendarUtils.getInstance());
            startCal.setTimeInMillis(start);
            endCal.setTimeInMillis(end);
            return new Calendar[]{startCal, endCal};
        }

        public static Calendar[] getLast6Months(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            calendarFrom.add(2, -6);
            CalendarRangeUtils.setAtDayStart(calendarFrom);
            return new Calendar[]{calendarFrom, referenceCalendar};
        }

        public static Calendar[] getThisYear(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            calendarFrom.set(2, calendarFrom.getActualMinimum(2));
            calendarFrom.set(5, 1);
            CalendarRangeUtils.setAtDayStart(calendarFrom);
            return new Calendar[]{calendarFrom, referenceCalendar};
        }

        public static Calendar[] getLastYear(Calendar referenceCalendar) {
            Calendar calendarFrom = (Calendar)referenceCalendar.clone();
            calendarFrom.add(1, -1);
            calendarFrom.set(2, calendarFrom.getActualMinimum(2));
            calendarFrom.set(5, 1);
            CalendarRangeUtils.setAtDayStart(calendarFrom);
            Calendar calendarTo = (Calendar)referenceCalendar.clone();
            calendarTo.add(1, -1);
            calendarTo.set(2, calendarTo.getActualMaximum(2));
            calendarTo.set(5, calendarTo.getActualMaximum(5));
            CalendarRangeUtils.setAtDayEnd(calendarTo);
            return new Calendar[]{calendarFrom, calendarTo};
        }
    }
}

