/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.database.DataSourceEntry;
import org.jboss.dashboard.database.ExternalDataSource;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;

@ApplicationScoped
public class DataSourceManager {
    public static final String DEFAULT_DATASOURCE_NAME = "local";
    private static transient Log log = LogFactory.getLog((String)DataSourceManager.class.getName());
    protected static transient ThreadLocal currentThreadDataSources = new ThreadLocal();

    @PostConstruct
    public void start() throws Exception {
        for (DataSourceEntry entry : this.getDataSourceEntries()) {
            this.checkDriverClassAvailable(entry.getDriverClass());
        }
    }

    public boolean checkDriverClassAvailable(String driverClassName) {
        try {
            if (!StringUtils.isBlank((String)driverClassName)) {
                Class.forName(driverClassName);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Driver class not found: " + driverClassName));
            return false;
        }
        return true;
    }

    public List<String> getDataSourceNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DEFAULT_DATASOURCE_NAME);
        for (DataSourceEntry entry : this.getDataSourceEntries()) {
            names.add(entry.getName());
        }
        return names;
    }

    public List<DataSourceEntry> getDataSourceEntries() {
        final ArrayList<DataSourceEntry> result = new ArrayList<DataSourceEntry>();
        try {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Query query = session.createQuery(" from " + DataSourceEntry.class.getName());
                    FlushMode oldFlushMode = session.getFlushMode();
                    session.setFlushMode(FlushMode.COMMIT);
                    query.setCacheable(true);
                    result.addAll(query.list());
                    session.setFlushMode(oldFlushMode);
                }
            }.execute();
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
        }
        return result;
    }

    public DataSourceEntry getDataSourceEntryByName(final String name) throws Exception {
        if (name == null) {
            return null;
        }
        final ArrayList results = new ArrayList();
        new HibernateTxFragment(){

            @Override
            protected void txFragment(Session session) throws Exception {
                FlushMode flushMode = session.getFlushMode();
                session.setFlushMode(FlushMode.COMMIT);
                StringBuffer sql = new StringBuffer();
                sql.append("select dse ");
                sql.append("from ").append(DataSourceEntry.class.getName()).append(" as dse ");
                sql.append("where dse.name = :name");
                Query query = session.createQuery(sql.toString());
                query.setString("name", name);
                query.setCacheable(true);
                results.addAll(query.list());
                session.setFlushMode(flushMode);
            }
        }.execute();
        if (results.size() > 0) {
            if (results.size() > 1) {
                log.error((Object)("There are " + results.size() + " data sources with name=" + name));
            }
            return (DataSourceEntry)results.get(0);
        }
        log.debug((Object)("Does not exists data source with name: " + name));
        return null;
    }

    public DataSource getDatasource(final String name) throws Exception {
        DataSource ds = this.getCurrentThreadDataSource(name);
        if (ds != null) {
            return ds;
        }
        final DataSourceEntry[] entryResult = new DataSourceEntry[]{null};
        try {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Query query = session.createQuery(" from " + DataSourceEntry.class.getName() + " entry where entry.name = :entryName ");
                    FlushMode oldFlushMode = session.getFlushMode();
                    session.setFlushMode(FlushMode.COMMIT);
                    query.setString("entryName", name);
                    query.setCacheable(true);
                    List results = query.list();
                    if (results.size() == 1) {
                        entryResult[0] = (DataSourceEntry)results.get(0);
                    } else {
                        log.warn((Object)("There are " + results.size() + " datasource entries with name " + name));
                    }
                    session.setFlushMode(oldFlushMode);
                }
            }.execute();
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
        }
        if (entryResult[0] == null) {
            return null;
        }
        ds = ExternalDataSource.lookup(name, entryResult[0]);
        this.setCurrentThreadDataSource(name, ds);
        return ds;
    }

    protected DataSource getCurrentThreadDataSource(String name) throws Exception {
        Map<String, DataSource> dsMap = this.getCurrentThreadDataSources();
        return dsMap.get(name);
    }

    protected void setCurrentThreadDataSource(String name, DataSource ds) throws Exception {
        Map<String, DataSource> dsMap = this.getCurrentThreadDataSources();
        dsMap.put(name, ds);
    }

    protected Map<String, DataSource> getCurrentThreadDataSources() throws Exception {
        HashMap<String, DataSource> dsMap = (HashMap<String, DataSource>)currentThreadDataSources.get();
        if (dsMap == null) {
            dsMap = new HashMap<String, DataSource>();
            DataSource localDataSource = CoreServices.lookup().getHibernateInitializer().getLocalDataSource();
            dsMap.put(DEFAULT_DATASOURCE_NAME, localDataSource);
            currentThreadDataSources.set(dsMap);
        }
        return dsMap;
    }
}

