/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jboss.dashboard.database.DataSourceEntry;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;

public class ExternalDataSource
implements DataSource {
    protected static transient Log log = LogFactory.getLog((String)ExternalDataSource.class.getName());
    protected String name = null;
    protected DataSourceEntry dataSourceEntry = null;
    protected transient Connection currentConnection = null;
    private PrintWriter printWriter = new PrintWriter(System.out);
    private int loginTimeOut = 0;
    private boolean disableAutoCommit = true;

    public static ExternalDataSource lookup(String name, DataSourceEntry dsEntry) {
        ExternalDataSource ds = new ExternalDataSource();
        ds.setName(name);
        ds.setDataSourceEntry(dsEntry);
        ds.setDisableAutoCommit(true);
        return ds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDataSourceEntry(DataSourceEntry dataSourceEntry) {
        this.dataSourceEntry = dataSourceEntry;
    }

    public DataSourceEntry getDataSourceEntry() {
        return this.dataSourceEntry;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeOut;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeOut = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    public boolean isDisableAutoCommit() {
        return this.disableAutoCommit;
    }

    public void setDisableAutoCommit(boolean disableAutoCommit) {
        this.disableAutoCommit = disableAutoCommit;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.currentConnection == null) {
            this.initConnection();
        }
        return this.currentConnection;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    protected void initConnection() {
        try {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    log.debug((Object)("Obtain data source connection: " + ExternalDataSource.this.name));
                    ExternalDataSource.this.dataSourceEntry = (DataSourceEntry)session.get(ExternalDataSource.this.dataSourceEntry.getClass(), (Serializable)ExternalDataSource.this.dataSourceEntry.getDbid());
                    Connection conn = ExternalDataSource.this.dataSourceEntry.getConnection();
                    ExternalDataSource.this.setAutoCommit(conn, !ExternalDataSource.this.disableAutoCommit);
                    ExternalDataSource.this.currentConnection = conn;
                    this.registerForCallbackNotifications();
                }

                @Override
                protected void beforeRollback() throws Exception {
                    ExternalDataSource.this.completeConnection(false);
                }

                @Override
                protected void afterRollback() throws Exception {
                    ExternalDataSource.this.completeConnection(false);
                }

                @Override
                protected void afterCommit() throws Exception {
                    ExternalDataSource.this.completeConnection(true);
                }
            }.execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void completeConnection(boolean commit) throws SQLException {
        if (this.currentConnection != null && !this.currentConnection.isClosed()) {
            if (!this.getAutoCommit(this.currentConnection)) {
                log.debug((Object)(commit ? "Commit" : "Rollback data source connection: " + this.name));
                if (commit) {
                    this.currentConnection.commit();
                } else {
                    this.currentConnection.rollback();
                }
            }
            this.currentConnection.close();
        }
        this.currentConnection = null;
    }

    protected boolean getAutoCommit(Connection conn) {
        try {
            return conn.getAutoCommit();
        }
        catch (SQLException e) {
            log.debug((Object)("Can not get autocommit for datasource: " + this.name), (Throwable)e);
            return true;
        }
    }

    protected void setAutoCommit(Connection conn, boolean autocommit) {
        try {
            if (this.getAutoCommit(conn) != autocommit) {
                conn.setAutoCommit(autocommit);
            }
        }
        catch (SQLException e) {
            log.debug((Object)("Can not set autocommit for datasource: " + this.name), (Throwable)e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> c) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> c) {
        return null;
    }
}

