/**
 * Copyright (C) 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.dashboard.database;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * A data source entry that gets the database connection via the JDBC protocol.
 */
public class JDBCDataSourceEntry extends DataSourceEntry {

    private static transient Log log = LogFactory.getLog(JDBCDataSourceEntry.class.getName());

    public Connection getConnection() throws SQLException {
        log.debug("Obtain connection from: " + getUrl());
        return DriverManager.getConnection(getUrl(), getUserName(), getPassword());
    }
}
