/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.io.DirectoriesScanner;
import org.jboss.dashboard.database.hibernate.HibernateInitializer;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.jboss.dashboard.error.ErrorManager;

@ApplicationScoped
public class DatabaseAutoSynchronizer {
    private static transient Log log = LogFactory.getLog((String)DatabaseAutoSynchronizer.class.getName());
    @Inject
    @Config(value="sql")
    protected String databaseConfigDir;
    @Inject
    @Config(value="dashb_installed_module")
    protected String installedModulesTable;
    @Inject
    @Config(value="delimiter //, //, , delimiter ;, GO")
    protected String[] excludedScriptStatements;
    @Inject
    @Config(value="-- CUSTOM_DELIMITER")
    protected String customDelimiter;
    @Inject
    @Config(value="-- ENABLE_CUSTOM_DELIMITER")
    protected String customDelimiterEnabler;

    public void synchronize(HibernateInitializer hibernateInitializer) throws Exception {
        String databaseName = hibernateInitializer.getDatabaseName();
        boolean tableExists = this.existsModulesTable();
        if (!tableExists) {
            this.createDatabase(databaseName);
        }
    }

    protected void createDatabase(String databaseName) throws Exception {
        File[] sqlFiles;
        String sqlDir = Application.lookup().getBaseCfgDirectory() + File.separator + this.databaseConfigDir;
        HashMap<String, File> sqlFileMap = new HashMap<String, File>();
        DirectoriesScanner scanner = new DirectoriesScanner("sql");
        for (File sqlFile : sqlFiles = scanner.findFiles(new File(sqlDir))) {
            if (!sqlFile.getName().endsWith(databaseName + ".sql") || !Character.isDigit(sqlFile.getName().charAt(0))) continue;
            sqlFileMap.put(sqlFile.getName(), sqlFile);
        }
        ArrayList sqlFileNames = new ArrayList(sqlFileMap.keySet());
        Collections.sort(sqlFileNames);
        for (String sqlFileName : sqlFileNames) {
            File sqlFile;
            sqlFile = (File)sqlFileMap.get(sqlFileName);
            this.runSQLFile(sqlFile);
        }
    }

    protected void runSQLFile(File f) throws Exception {
        if (f.exists() && f.isFile()) {
            log.warn((Object)("Running file " + f.getName()));
            BufferedReader reader = new BufferedReader(new FileReader(f));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            this.runDDL(sb.toString());
        }
    }

    protected void runDDL(String ddl) throws Exception {
        String separator = ";";
        if (ddl.startsWith(this.customDelimiterEnabler)) {
            separator = this.customDelimiter;
        }
        String[] statements = this.splitString(ddl, separator);
        for (int i = 0; i < statements.length; ++i) {
            final String ddlStatement = this.removeComments(statements[i]);
            if (ArrayUtils.contains((Object[])this.excludedScriptStatements, (Object)ddlStatement)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running statement: " + ddlStatement));
            }
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Work w = new Work(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void execute(Connection connection) throws SQLException {
                            Statement statement = null;
                            try {
                                statement = connection.createStatement();
                                statement.execute(ddlStatement);
                            }
                            catch (Exception e) {
                                Throwable root = ErrorManager.lookup().getRootCause(e);
                                log.error((Object)("Error executing " + ddlStatement + ": " + root.getMessage()));
                            }
                            finally {
                                if (statement != null) {
                                    statement.close();
                                }
                            }
                        }
                    };
                    session.doWork(w);
                    session.flush();
                }
            }.execute();
        }
    }

    private String[] splitString(String str, String delims) {
        if (str == null) {
            return null;
        }
        if (str.equals("") || delims == null || delims.length() == 0) {
            return new String[]{str};
        }
        Vector<String> v = new Vector<String>();
        int pos = 0;
        int newpos = str.indexOf(delims, pos);
        while (newpos != -1) {
            v.addElement(str.substring(pos, newpos));
            pos = newpos + delims.length();
            newpos = str.indexOf(delims, pos);
        }
        v.addElement(str.substring(pos));
        String[] s = new String[v.size()];
        int cnt = s.length;
        for (int i = 0; i < cnt; ++i) {
            s[i] = ((String)v.elementAt(i)).trim();
        }
        return s;
    }

    protected String removeComments(String ddlStatement) {
        StringBuffer sb = new StringBuffer();
        BufferedReader strreader = new BufferedReader(new StringReader(ddlStatement));
        String line = null;
        try {
            while ((line = strreader.readLine()) != null) {
                if (line.trim().startsWith("--")) continue;
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            log.error((Object)"Error: ", (Throwable)e);
        }
        return sb.toString().trim();
    }

    protected boolean existsModulesTable() throws Exception {
        final boolean[] returnValue = new boolean[]{false};
        new HibernateTxFragment(true){

            @Override
            protected void txFragment(Session session) throws Exception {
                Work w = new Work(){

                    public void execute(Connection connection) throws SQLException {
                        DatabaseMetaData metaData = connection.getMetaData();
                        returnValue[0] = metaData.getTables(null, null, DatabaseAutoSynchronizer.this.installedModulesTable.toLowerCase(), null).next();
                        if (!returnValue[0]) {
                            returnValue[0] = metaData.getTables(null, null, DatabaseAutoSynchronizer.this.installedModulesTable.toUpperCase(), null).next();
                        }
                    }
                };
                session.doWork(w);
            }
        }.execute();
        return returnValue[0];
    }
}

