/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.commons.misc.ReflectionUtils;
import org.jboss.dashboard.error.ErrorManager;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.CodeBlockType;
import org.jboss.dashboard.profiler.CoreCodeBlockTypes;

public class NonPooledDataSource
implements DataSource {
    private static transient Log log = LogFactory.getLog((String)NonPooledDataSource.class.getName());
    protected PrintWriter printWriter;
    protected int loginTimeOut = 0;
    protected String url;
    protected String user;
    protected String password;
    protected String driver;
    protected int isolation = 8;
    protected boolean autoCommit = false;
    protected transient Map<Class, Class[]> _classInterfacesMap = new HashMap<Class, Class[]>();

    public NonPooledDataSource() {
        this.printWriter = new PrintWriter(System.out);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public int getIsolation() {
        return this.isolation;
    }

    public void setIsolation(int isolation) {
        this.isolation = isolation;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeOut;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeOut = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Class.forName(this.driver);
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            this.setAutoCommit(conn, this.autoCommit);
            this.setIsolation(conn, this.isolation);
            return this.createConnectionProxy(conn);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    protected boolean getAutoCommit(Connection conn) {
        try {
            return conn.getAutoCommit();
        }
        catch (SQLException e) {
            log.debug((Object)"Can not get autocommit.", (Throwable)e);
            return true;
        }
    }

    protected void setAutoCommit(Connection conn, boolean autocommit) {
        try {
            if (this.getAutoCommit(conn) != autocommit) {
                conn.setAutoCommit(autocommit);
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Can not set autocommit.", (Throwable)e);
        }
    }

    protected void setIsolation(Connection conn, int isolation) {
        try {
            if (conn.getTransactionIsolation() != isolation) {
                conn.setTransactionIsolation(isolation);
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Can not set connection isolation.", (Throwable)e);
        }
    }

    public Connection createConnectionProxy(Connection conn) throws SQLException {
        return (Connection)Proxy.newProxyInstance(conn.getClass().getClassLoader(), this.getClassInterfaces(conn.getClass()), (InvocationHandler)new ConnectionInvocationHandler(conn));
    }

    protected Class[] getClassInterfaces(Class clazz) {
        Class[] result = this._classInterfacesMap.get(clazz);
        if (result != null) {
            return result;
        }
        result = ReflectionUtils.getClassHierarchyInterfaces(clazz);
        this._classInterfacesMap.put(clazz, result);
        return result;
    }

    protected Statement createStatementProxy(Statement stmt) throws SQLException {
        return (Statement)Proxy.newProxyInstance(stmt.getClass().getClassLoader(), this.getClassInterfaces(stmt.getClass()), (InvocationHandler)new StatementInvocationHandler(stmt));
    }

    protected Statement createPreparedStatementProxy(PreparedStatement stmt, String sql) throws SQLException {
        return (Statement)Proxy.newProxyInstance(stmt.getClass().getClassLoader(), this.getClassInterfaces(stmt.getClass()), (InvocationHandler)new PreparedStatementInvocationHandler(stmt, sql));
    }

    static class SQLStatementTrace
    extends CodeBlockTrace {
        protected Map<String, Object> context = new HashMap<String, Object>();

        public SQLStatementTrace(String sql) {
            super(SQLStatementTrace.stripAfterWhere(sql));
            this.context.put("SQL", sql);
        }

        @Override
        public CodeBlockType getType() {
            return CoreCodeBlockTypes.SQL;
        }

        @Override
        public String getDescription() {
            return (String)this.context.get("SQL");
        }

        @Override
        public Map<String, Object> getContext() {
            return this.context;
        }

        public static String stripAfterWhere(String sql) {
            for (int i = 0; i < sql.length() - 4; ++i) {
                if (sql.charAt(i) != 'w' && sql.charAt(i) != 'W' || !sql.substring(i + 1, i + 5).equalsIgnoreCase("here")) continue;
                return sql.substring(0, i);
            }
            return sql;
        }
    }

    static class PreparedStatementInvocationHandler
    extends StatementInvocationHandler {
        protected String sql;

        public PreparedStatementInvocationHandler(Statement stmt, String sql) {
            super(stmt);
            this.sql = sql;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            if (m.getName().startsWith("execute")) {
                String sqlToExec = args != null && args.length > 0 ? (String)args[0] : this.sql;
                CodeBlockTrace trace = new SQLStatementTrace(sqlToExec).begin();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sqlToExec);
                    }
                    Object object = m.invoke((Object)this.stmt, args);
                    return object;
                }
                catch (Throwable e) {
                    ErrorManager.lookup().notifyError(e, true);
                    throw e;
                }
                finally {
                    trace.end();
                }
            }
            return m.invoke((Object)this.stmt, args);
        }
    }

    static class StatementInvocationHandler
    implements InvocationHandler {
        protected Statement stmt;

        public StatementInvocationHandler(Statement stmt) {
            this.stmt = stmt;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            if (m.getName().startsWith("execute") && args != null && args.length > 0) {
                String sqlToExec = (String)args[0];
                CodeBlockTrace trace = new SQLStatementTrace(sqlToExec).begin();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sqlToExec);
                    }
                    Object object = m.invoke((Object)this.stmt, args);
                    return object;
                }
                catch (Throwable e) {
                    ErrorManager.lookup().notifyError(e, true);
                    throw e;
                }
                finally {
                    trace.end();
                }
            }
            return m.invoke((Object)this.stmt, args);
        }
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        private Connection conn = null;

        public ConnectionInvocationHandler(Connection conn) {
            this.conn = conn;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            if (m.getName().equals("commit")) {
                CodeBlockTrace trace = new SQLStatementTrace("commit").begin();
                try {
                    Object object = m.invoke((Object)this.conn, args);
                    return object;
                }
                catch (Throwable e) {
                    ErrorManager.lookup().notifyError(e, true);
                    throw e;
                }
                finally {
                    trace.end();
                }
            }
            if (m.getName().equals("rollback")) {
                CodeBlockTrace trace = new SQLStatementTrace("rollback").begin();
                try {
                    Object e = m.invoke((Object)this.conn, args);
                    return e;
                }
                catch (Throwable e) {
                    ErrorManager.lookup().notifyError(e, true);
                    throw e;
                }
                finally {
                    trace.end();
                }
            }
            Object result = m.invoke((Object)this.conn, args);
            if (m.getReturnType() != null) {
                if (m.getReturnType().equals(PreparedStatement.class)) {
                    String sql = (String)args[0];
                    return NonPooledDataSource.this.createPreparedStatementProxy((PreparedStatement)result, sql);
                }
                if (m.getReturnType().equals(Statement.class)) {
                    return NonPooledDataSource.this.createStatementProxy((Statement)result);
                }
            }
            return result;
        }
    }
}

