/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.jboss.dashboard.annotation.Priority;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.database.InstalledModule;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.jboss.dashboard.factory.InitialModule;
import org.jboss.dashboard.factory.InitialModuleRegistry;

@ApplicationScoped
public class InitialModulesManager
implements Startable {
    public static transient Log log = LogFactory.getLog((String)InitialModulesManager.class.getName());
    @Inject
    private InitialModuleRegistry initialModuleRegistry;

    @Override
    public Priority getPriority() {
        return Priority.LOW;
    }

    @Override
    public void start() throws Exception {
        List<InitialModule> modules = this.initialModuleRegistry.getInitialModulesRegistered();
        for (final InitialModule module : modules) {
            new HibernateTxFragment(true){

                @Override
                protected void txFragment(Session session) throws Exception {
                    InstalledModule currentVersion = (InstalledModule)session.get(InstalledModule.class, (Serializable)((Object)module.getName()), LockOptions.UPGRADE);
                    if (currentVersion == null) {
                        if (module.doTheInstall()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Installed module " + module.getName() + " version " + module.getVersion()));
                            }
                            currentVersion = new InstalledModule(module.getName(), 1L);
                            session.save((Object)currentVersion);
                            session.flush();
                        } else {
                            log.warn((Object)("Error installing module " + module.getName() + " version " + module.getVersion()));
                        }
                    } else if (currentVersion.getVersion() < module.getVersion()) {
                        if (module.doTheUpgrade(currentVersion.getVersion())) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Upgraded module " + module.getName() + " to version " + module.getVersion()));
                            }
                            currentVersion.setVersion(module.getVersion());
                            session.saveOrUpdate((Object)currentVersion);
                            session.flush();
                        } else {
                            log.warn((Object)("Error upgrading module " + module.getName() + " to version " + module.getVersion()));
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("Module " + module.getName() + " version " + module.getVersion() + "is already installed."));
                    }
                }
            }.execute();
        }
    }
}

