/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.util.Hashtable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.factory.ComponentsStorage;

public class LookupHelper {
    private static transient Log log = LogFactory.getLog((String)LookupHelper.class.getName());
    private Hashtable storages = new Hashtable();

    public void addStorageResolver(String scope, ComponentsStorage storage) {
        this.storages.put(scope, storage);
    }

    public Object lookupObject(String scope, String name) {
        ComponentsStorage storage = (ComponentsStorage)this.storages.get(scope);
        if (storage == null) {
            log.error((Object)("Cannot resolve components with scope " + scope));
            return null;
        }
        return storage.getComponent(name);
    }

    public void storeObject(String scope, String name, Object instance) {
        ComponentsStorage storage = (ComponentsStorage)this.storages.get(scope);
        if (storage == null) {
            log.error((Object)("Cannot store components with scope " + scope));
        } else {
            storage.setComponent(name, instance);
        }
    }

    public void clear() {
        Set scopes = this.storages.keySet();
        for (String scope : scopes) {
            ComponentsStorage storage = (ComponentsStorage)this.storages.get(scope);
            storage.clear();
        }
        this.storages.clear();
    }

    public Object getSynchronizationObject(String scope) {
        ComponentsStorage storage = (ComponentsStorage)this.storages.get(scope);
        if (storage == null) {
            log.error((Object)("Cannot resolve components with scope " + scope));
            return "";
        }
        return storage.getSynchronizationObject();
    }
}

