/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.factory.Component;
import org.jboss.dashboard.factory.LookupException;

public abstract class PropertyChangeProcessingInstruction {
    private static transient Log log = LogFactory.getLog((String)PropertyChangeProcessingInstruction.class.getName());
    private String propertyName;
    private String propertyValue;
    private Component component;
    public static final String ARRAYS_DELIMITER = ",";

    protected PropertyChangeProcessingInstruction(Component component, String propertyName, String propertyValue) {
        this.component = component;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public abstract Object getValueAfterChange(Object var1, Class var2) throws Exception;

    protected Object getNewInstanceForClass(Class expectedClass) {
        log.debug((Object)("Creating 'empty' class of type " + expectedClass));
        Object object = null;
        if (expectedClass.isArray()) {
            Class<?> componentClass = expectedClass.getComponentType();
            if (componentClass.isPrimitive()) {
                if (componentClass.equals(Integer.TYPE)) {
                    object = new int[0];
                } else if (componentClass.equals(Boolean.TYPE)) {
                    object = new boolean[0];
                } else if (componentClass.equals(Long.TYPE)) {
                    object = new long[0];
                } else if (componentClass.equals(Character.TYPE)) {
                    object = new char[0];
                } else if (componentClass.equals(Double.TYPE)) {
                    object = new double[0];
                } else if (componentClass.equals(Float.TYPE)) {
                    object = new float[0];
                } else if (componentClass.equals(Byte.TYPE)) {
                    object = new byte[0];
                } else if (componentClass.equals(Short.TYPE)) {
                    object = new short[0];
                }
            } else {
                object = String.class.equals(componentClass) ? new String[]{} : (componentClass.equals(Integer.class) ? new Integer[]{} : (componentClass.equals(Boolean.class) ? new Boolean[]{} : (componentClass.equals(Long.class) ? new Long[]{} : (componentClass.equals(Character.class) ? new Character[]{} : (componentClass.equals(Double.class) ? new Double[]{} : (componentClass.equals(Float.class) ? new Float[]{} : (componentClass.equals(Byte.class) ? new Byte[]{} : (componentClass.equals(Short.class) ? new Short[]{} : Array.newInstance(componentClass, 0)))))))));
            }
        } else {
            object = String.class.equals((Object)expectedClass) ? "" : (expectedClass.equals(Integer.TYPE) ? new Integer(0) : (expectedClass.equals(Boolean.TYPE) ? new Boolean(false) : (expectedClass.equals(Long.TYPE) ? new Long(0L) : (expectedClass.equals(Character.TYPE) ? new Character('\u0000') : (expectedClass.equals(Double.TYPE) ? new Double(0.0) : (expectedClass.equals(Float.TYPE) ? new Float(0.0f) : (expectedClass.equals(Byte.TYPE) ? new Byte(0) : (expectedClass.equals(Short.TYPE) ? new Short(0) : (expectedClass.equals(Integer.class) ? new Integer(0) : (expectedClass.equals(Boolean.class) ? new Boolean(false) : (expectedClass.equals(Long.class) ? new Long(0L) : (expectedClass.equals(Character.class) ? (Serializable)new Character('\u0000') : (Serializable)(expectedClass.equals(Double.class) ? (Number)new Double(0.0) : (Number)(expectedClass.equals(Float.class) ? (Number)new Float(0.0f) : (Number)(expectedClass.equals(Byte.class) ? (Number)new Byte(0) : (Number)(expectedClass.equals(Short.class) ? new Short(0) : null))))))))))))))));
        }
        return object;
    }

    protected Object getValueForParameter(String paramValue, Class expectedClass) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting value with class " + expectedClass + ", parsing " + paramValue));
        }
        Object object = null;
        if (expectedClass.isArray()) {
            Class<?> componentClass = expectedClass.getComponentType();
            if (componentClass.isArray()) {
                throw new Exception("Nested array properties are not supported.");
            }
            ArrayList<Object> objectValue = new ArrayList<Object>();
            StringTokenizer stk = new StringTokenizer(paramValue, ARRAYS_DELIMITER, true);
            while (stk.hasMoreTokens()) {
                String token = stk.nextToken();
                int delimiterCount = 0;
                boolean addTrailingToken = true;
                while (ARRAYS_DELIMITER.equals(token)) {
                    addTrailingToken = false;
                    if (++delimiterCount % 2 == 0) {
                        String lastToken = (String)objectValue.get(objectValue.size() - 1);
                        objectValue.set(objectValue.size() - 1, lastToken + ARRAYS_DELIMITER);
                        if (stk.hasMoreTokens()) {
                            token = stk.nextToken();
                            if (ARRAYS_DELIMITER.equals(token)) continue;
                            lastToken = (String)objectValue.get(objectValue.size() - 1);
                            objectValue.remove(objectValue.size() - 1);
                            objectValue.add(lastToken + token);
                            continue;
                        }
                        addTrailingToken = false;
                        break;
                    }
                    if (delimiterCount % 2 == 1 && !stk.hasMoreTokens()) {
                        objectValue.add("");
                        continue;
                    }
                    if (!stk.hasMoreTokens()) continue;
                    token = stk.nextToken();
                    addTrailingToken = true;
                }
                if (!addTrailingToken) continue;
                objectValue.add(token);
            }
            for (int i = 0; i < objectValue.size(); ++i) {
                String s = (String)objectValue.get(i);
                objectValue.set(i, this.getValueForParameter(s, componentClass));
            }
            Object baseObjectArray = this.getBaseArray(componentClass, objectValue.size());
            object = objectValue.toArray((Object[])baseObjectArray);
        } else {
            object = String.class.equals((Object)expectedClass) ? paramValue : (expectedClass.equals(Integer.TYPE) ? new Integer(this.toInt(paramValue)) : (expectedClass.equals(Boolean.TYPE) ? (this.toBoolean(paramValue) ? Boolean.TRUE : Boolean.FALSE) : (expectedClass.equals(Long.TYPE) ? new Long(this.toLong(paramValue)) : (expectedClass.equals(Character.TYPE) ? new Character(this.toChar(paramValue)) : (expectedClass.equals(Double.TYPE) ? new Double(this.toDouble(paramValue)) : (expectedClass.equals(Float.TYPE) ? new Float(this.toFloat(paramValue)) : (expectedClass.equals(Byte.TYPE) ? new Byte(this.toByte(paramValue)) : (expectedClass.equals(Short.TYPE) ? new Short(this.toShort(paramValue)) : (expectedClass.equals(File.class) ? this.toFile(paramValue) : (expectedClass.equals(Integer.class) ? new Integer(this.toInt(paramValue)) : (expectedClass.equals(Boolean.class) ? (this.toBoolean(paramValue) ? Boolean.TRUE : Boolean.FALSE) : (expectedClass.equals(Long.class) ? new Long(this.toLong(paramValue)) : (expectedClass.equals(Character.class) ? new Character(this.toChar(paramValue)) : (expectedClass.equals(Double.class) ? new Double(this.toDouble(paramValue)) : (expectedClass.equals(Float.class) ? new Float(this.toFloat(paramValue)) : (expectedClass.equals(Byte.class) ? new Byte(this.toByte(paramValue)) : (expectedClass.equals(Short.class) ? new Short(this.toShort(paramValue)) : this.toComponent(paramValue))))))))))))))))));
        }
        return object;
    }

    protected Object getBaseArray(Class expectedClass, int length) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating base array with length " + length + " and class " + expectedClass));
        }
        if (expectedClass.isPrimitive()) {
            if (expectedClass.equals(Integer.TYPE)) {
                return new Integer[length];
            }
            if (expectedClass.equals(Boolean.TYPE)) {
                return new Boolean[length];
            }
            if (expectedClass.equals(Long.TYPE)) {
                return new Long[length];
            }
            if (expectedClass.equals(Character.TYPE)) {
                return new Character[length];
            }
            if (expectedClass.equals(Double.TYPE)) {
                return new Double[length];
            }
            if (expectedClass.equals(Float.TYPE)) {
                return new Float[length];
            }
            if (expectedClass.equals(Byte.TYPE)) {
                return new Byte[length];
            }
            if (expectedClass.equals(Short.TYPE)) {
                return new Short[length];
            }
        }
        return Array.newInstance(expectedClass, length);
    }

    protected int toInt(String parameter) throws Exception {
        return Integer.parseInt(parameter);
    }

    protected boolean toBoolean(String parameter) throws Exception {
        return Boolean.valueOf(parameter);
    }

    protected long toLong(String parameter) throws Exception {
        return Long.parseLong(parameter);
    }

    protected char toChar(String parameter) throws Exception {
        if (parameter.length() != 1) {
            throw new Exception("Invalid value for a char " + parameter);
        }
        return parameter.charAt(0);
    }

    protected double toDouble(String parameter) throws Exception {
        return Double.parseDouble(parameter);
    }

    protected float toFloat(String parameter) throws Exception {
        return Float.parseFloat(parameter);
    }

    protected byte toByte(String parameter) throws Exception {
        return Byte.parseByte(parameter);
    }

    protected short toShort(String parameter) throws Exception {
        return Short.parseShort(parameter);
    }

    protected Object toFile(String paramValue) {
        if (paramValue == null || "".equals(paramValue.trim())) {
            return null;
        }
        if (paramValue.startsWith("/") || paramValue.indexOf(":") != -1) {
            return new File(paramValue);
        }
        return new File(Application.lookup().getBaseAppDirectory() + "/" + paramValue);
    }

    protected Object toComponent(String parameter) throws Exception {
        if (parameter == null || "".equals(parameter)) {
            return null;
        }
        Object o = null;
        try {
            o = this.getComponent().getTree().lookup(parameter, this.getComponent().getName());
        }
        catch (LookupException e) {
            log.error((Object)("Error looking up component: " + parameter + ". Trying to set property for component " + this.getComponent().getName()), (Throwable)e);
        }
        if (o == null) {
            log.error((Object)("Invalid component specified for property " + this.propertyName + " in " + this.component.getName() + ": '" + parameter + "'. Lookup is null."));
            if (!parameter.equals(parameter.trim())) {
                log.error((Object)"Component name contains blank spaces at the beginning or end. This is probably the cause of previous error(s).");
            }
        }
        return o;
    }

    protected Component getComponent() {
        return this.component;
    }
}

