/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.commons.comparator.ComparatorUtils;

public class StartableProcessor {
    private static transient Log log = LogFactory.getLog((String)StartableProcessor.class.getName());
    @Inject
    protected Instance<Startable> startables;
    protected StartableComparator startableComparator = new StartableComparator();

    public void wakeUpStartableBeans() throws Exception {
        ArrayList<Startable> startableList = new ArrayList<Startable>();
        for (Startable startable : this.startables) {
            startableList.add(startable);
        }
        Collections.sort(startableList, this.startableComparator);
        for (Startable startable : startableList) {
            try {
                log.debug((Object)("Starting " + (Object)((Object)startable.getPriority()) + " priority bean " + startable.getClass().getName()));
                startable.start();
            }
            catch (Exception e) {
                log.error((Object)("Error starting bean " + startable.getClass().getName()), (Throwable)e);
            }
        }
    }

    private class StartableComparator
    implements Comparator {
        private StartableComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                Startable s1 = (Startable)o1;
                Startable s2 = (Startable)o2;
                return ComparatorUtils.compare(Integer.valueOf(s1.getPriority().getWeight()), Integer.valueOf(s2.getPriority().getWeight()), -1);
            }
            catch (ClassCastException e) {
                return 0;
            }
        }
    }
}

