/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.jboss.dashboard.commons.misc.ReflectionUtils;
import org.jboss.dashboard.database.hibernate.HibernateTransaction;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.CodeBlockType;
import org.jboss.dashboard.profiler.CoreCodeBlockTypes;
import org.jboss.dashboard.profiler.Profiler;
import org.jboss.dashboard.profiler.ThreadProfile;

public abstract class HibernateTxFragment {
    private static transient Log log = LogFactory.getLog((String)HibernateTxFragment.class.getName());
    private boolean alreadyExecuted;
    protected boolean newTransactionRequested;
    protected boolean flushAfterFinish;
    protected boolean callbacksEnabled;
    protected HibernateTxFragment parentFragment;

    public HibernateTxFragment() {
        this(false, false);
    }

    public HibernateTxFragment(boolean newTransactionRequested) {
        this(newTransactionRequested, false);
    }

    public HibernateTxFragment(boolean newTransactionRequested, boolean callbacksEnabled) {
        this(newTransactionRequested, callbacksEnabled, false);
    }

    public HibernateTxFragment(boolean newTransactionRequested, boolean callbacksEnabled, boolean flushAfterFinish) {
        this.newTransactionRequested = newTransactionRequested;
        this.callbacksEnabled = callbacksEnabled;
        this.flushAfterFinish = flushAfterFinish;
        this.alreadyExecuted = false;
        this.parentFragment = null;
    }

    protected void registerForCallbackNotifications() {
        this.callbacksEnabled = true;
    }

    protected void markAsRollbackOnly() {
        HibernateTransaction tx = HibernateTransaction.getCurrentTx();
        tx.setRollback(true);
    }

    protected void markAsRollbackOnly(Throwable t) {
        HibernateTransaction tx = HibernateTransaction.getCurrentTx();
        tx.error(t);
    }

    public final void execute() throws Exception {
        if (this.alreadyExecuted) {
            log.error((Object)"Double execution of fragment is not allowed.");
        } else {
            HibernateTransaction tx = HibernateTransaction.getCurrentTx();
            if (!tx.isActive()) {
                this.executeInitiator(tx);
            } else {
                this.executeChild(tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeInitiator(HibernateTransaction tx) throws Exception {
        tx.begin();
        CodeBlockTrace trace = new HibernateTxTrace(tx).begin();
        try {
            this.alreadyExecuted = true;
            tx.executeFragment(this);
        }
        finally {
            tx.complete();
            trace.end();
        }
    }

    protected final void executeChild(HibernateTransaction tx) throws Exception {
        if (this.newTransactionRequested) {
            tx.followers.add(this);
        } else {
            this.alreadyExecuted = true;
            tx.executeFragment(this);
        }
    }

    protected void txFragment(Session session) throws Throwable {
    }

    protected void beforeCommit() throws Throwable {
    }

    protected void beforeRollback() throws Throwable {
    }

    protected void afterRollback() throws Throwable {
    }

    protected void afterCommit() throws Throwable {
    }

    class HibernateTxTrace
    extends CodeBlockTrace {
        public static final String CONNECTION_ID = "Tx Connection id";
        public static final String PROCESS_ID = "Tx Process id";
        public static final String TX_ISOLATION = "Tx Isolation";
        public static final String AUTO_COMMIT = "Tx Auto commit";
        protected Map<String, Object> context;

        public HibernateTxTrace(HibernateTransaction tx) throws Exception {
            super(Integer.toString(tx.hashCode()));
            this.context = this.buildContext(tx);
        }

        @Override
        public CodeBlockType getType() {
            return CoreCodeBlockTypes.TRANSACTION;
        }

        @Override
        public String getDescription() {
            return "Transaction " + this.id;
        }

        @Override
        public Map<String, Object> getContext() {
            return this.context;
        }

        public Map<String, Object> buildContext(HibernateTransaction tx) throws Exception {
            final LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
            tx.getSession().doWork(new Work(){

                public void execute(Connection conn) throws SQLException {
                    ThreadProfile threadProfile;
                    Object connId;
                    Object spid;
                    ctx.put("Tx id", HibernateTxTrace.this.id);
                    ctx.put(HibernateTxTrace.TX_ISOLATION, Integer.toString(conn.getTransactionIsolation()));
                    ctx.put(HibernateTxTrace.AUTO_COMMIT, conn.getAutoCommit());
                    Object tdsChannel = ReflectionUtils.getPrivateField(conn, "tdsChannel");
                    if (tdsChannel != null && (spid = ReflectionUtils.getPrivateField(tdsChannel, "spid")) != null) {
                        ctx.put(HibernateTxTrace.PROCESS_ID, spid.toString());
                    }
                    if ((connId = ReflectionUtils.getPrivateField(conn, "connectionID")) == null) {
                        connId = ReflectionUtils.getPrivateField(conn, "traceID");
                    }
                    if (connId != null) {
                        ctx.put(HibernateTxTrace.CONNECTION_ID, connId.toString());
                    }
                    if ((threadProfile = Profiler.lookup().getCurrentThreadProfile()) != null) {
                        threadProfile.addContextProperties(ctx);
                    }
                }
            });
            return ctx;
        }
    }
}

