/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.hibernate;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.database.hibernate.HibernateInitializer;
import org.jboss.dashboard.database.hibernate.LOBHelper;

public class StringBlobType
implements UserType,
Serializable {
    private static transient Log log = LogFactory.getLog((String)StringBlobType.class.getName());
    public static final String STRING_ENCODING = "UTF-8";

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return String.class;
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && y != null && x.equals(y);
    }

    public int hashCode(Object o) throws HibernateException {
        return o == null ? 0 : o.hashCode();
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        LOBHelper.lookup().nullSafeSet(st, value, index, new LOBHelper.ValueWriter(){

            @Override
            public void writeValue(OutputStream os, Object value) throws IOException {
                if (value != null) {
                    os.write(((String)value).getBytes(StringBlobType.STRING_ENCODING));
                }
            }

            @Override
            public void writeValue(PreparedStatement st, Object value, int index) throws SQLException {
                HibernateInitializer hi = CoreServices.lookup().getHibernateInitializer();
                if (hi.isPostgresDatabase()) {
                    st.setString(index, (String)value);
                } else if (hi.isH2Database()) {
                    st.setString(index, (String)value);
                } else if (hi.isMySQLDatabase()) {
                    try {
                        st.setBytes(index, value == null ? null : ((String)value).getBytes(StringBlobType.STRING_ENCODING));
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error((Object)"Error: ", (Throwable)e);
                    }
                } else if (hi.isSQLServerDatabase()) {
                    st.setString(index, (String)value);
                } else {
                    throw new IllegalArgumentException("Unknown database name: " + hi.getDatabaseName());
                }
            }
        });
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object o;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting value with names " + Arrays.asList(names)));
        }
        if ((o = rs.getObject(names[0])) == null) {
            return null;
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            try {
                byte[] bytes = blob.getBytes(1L, (int)blob.length());
                if (bytes == null) {
                    return null;
                }
                return new String(bytes, STRING_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Error:", (Throwable)e);
                return new String(blob.getBytes(1L, (int)blob.length()));
            }
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof byte[]) {
            try {
                return new String((byte[])o, STRING_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Error: ", (Throwable)e);
                return null;
            }
        }
        if (o instanceof Clob) {
            Clob clob = (Clob)o;
            return clob.getSubString(1L, (int)clob.length());
        }
        throw new IllegalArgumentException("Unexpected value read. Must be Blob or String, but it is " + o.getClass());
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        throw new IllegalArgumentException("Unexpected value to copy. Must be String, but it is " + value.getClass());
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object o) throws HibernateException {
        if (o == null) {
            return null;
        }
        return (String)o;
    }

    public Object assemble(Serializable serializable, Object owner) throws HibernateException {
        if (serializable == null) {
            return null;
        }
        return serializable.toString();
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

