/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.factory.ComponentsContextManager;
import org.jboss.dashboard.log.LoggerSet;
import org.jboss.dashboard.log.MemoryAppender;
import org.jboss.dashboard.profiler.Profiler;
import org.jboss.dashboard.profiler.ThreadProfile;

@ApplicationScoped
public class Log4JManager
implements Startable {
    protected List<LoggerSet> loggerSets;
    @Inject
    @Config(value="MEMORY")
    protected String memoryAppenderName;
    @Inject
    @Config(value="[%t %d{MM/dd/yyyy HH:mm:ss}] %-5p %C{6} (%F:%L) - %m [%X{ADDS}]%n")
    protected String memoryAppenderPattern;
    @Inject
    @Config(value="10000")
    protected int memoryAppenderBufferSize;
    @Inject
    @Config(value="500")
    protected long highThroughput;
    @Inject
    @Config(value="false")
    protected boolean highTroughputAllowed;
    @Inject
    @Config(value="5000")
    protected long highTroughputMaxTime;
    protected MemoryAppender memoryAppender;
    protected transient long _numberOfEvents = 0L;
    protected transient long _startTime = System.currentTimeMillis();
    protected transient long _highThroughputCount = 0L;
    protected transient long _throughput;

    public String getMemoryAppenderName() {
        return this.memoryAppenderName;
    }

    public void setMemoryAppenderName(String memoryAppenderName) {
        this.memoryAppenderName = memoryAppenderName;
    }

    public String getMemoryAppenderPattern() {
        return this.memoryAppenderPattern;
    }

    public void setMemoryAppenderPattern(String memoryAppenderPattern) {
        this.memoryAppenderPattern = memoryAppenderPattern;
    }

    public int getMemoryAppenderBufferSize() {
        return this.memoryAppenderBufferSize;
    }

    public void setMemoryAppenderBufferSize(int memoryAppenderBufferSize) {
        this.memoryAppenderBufferSize = memoryAppenderBufferSize;
    }

    public MemoryAppender getMemoryAppender() {
        return this.memoryAppender;
    }

    public List<LoggerSet> getLoggerSets() {
        return Collections.unmodifiableList(this.loggerSets);
    }

    public void addLoggerSet(LoggerSet loggerSet) {
        this.loggerSets.add(loggerSet);
    }

    public void removeLoggerSet(LoggerSet loggerSet) {
        if (loggerSet.isEditable()) {
            this.loggerSets.remove(loggerSet);
            loggerSet.setLevel(null);
        }
    }

    public LoggerSet getLoggerSetById(Long id) {
        for (LoggerSet loggerSet : this.loggerSets) {
            if (!loggerSet.id.equals(id)) continue;
            return loggerSet;
        }
        return null;
    }

    public void setLoggerSetsLevel(Level level) {
        for (LoggerSet loggerSet : this.loggerSets) {
            loggerSet.setLevel(level);
        }
    }

    public long getHighThroughput() {
        return this.highThroughput;
    }

    public void setHighThroughput(long highThroughput) {
        this.highThroughput = highThroughput;
    }

    public boolean isHighTroughputAllowed() {
        return this.highTroughputAllowed;
    }

    public void setHighTroughputAllowed(boolean highTroughputAllowed) {
        this.highTroughputAllowed = highTroughputAllowed;
    }

    public long getHighTroughputMaxTime() {
        return this.highTroughputMaxTime;
    }

    public void setHighTroughputMaxTime(long highTroughputMaxTime) {
        this.highTroughputMaxTime = highTroughputMaxTime;
    }

    public long getThroughput() {
        return this._throughput;
    }

    protected void calculateThroughput() {
        long now = System.currentTimeMillis();
        if (now - this._startTime < 1000L) {
            ++this._numberOfEvents;
        } else {
            this._throughput = this._numberOfEvents;
            this._highThroughputCount = this._throughput > this.highThroughput ? ++this._highThroughputCount : 0L;
            this._startTime = now;
            this._numberOfEvents = 0L;
        }
    }

    void onAppend(LoggingEvent event) {
        ThreadProfile threadProfile;
        if (ComponentsContextManager.isContextStarted() && (threadProfile = Profiler.lookup().getCurrentThreadProfile()) != null) {
            threadProfile.addLog4JEvent(event);
        }
        this.calculateThroughput();
        if (!this.highTroughputAllowed && this._highThroughputCount > 0L && this._highThroughputCount > this.highTroughputMaxTime / 1000L) {
            this.setLoggerSetsLevel(Level.FATAL);
            String warnMessage = "\nWARNING: Log4J High throughput detected (more than " + this.getHighThroughput() + " events per second). All log levels set to FATAL.\n";
            LoggingEvent warnEvent = new LoggingEvent(Category.class.getName(), (Category)Logger.getRootLogger(), (Priority)Level.WARN, (Object)warnMessage, null);
            this.memoryAppender.buffer.addLast(warnEvent);
            System.out.println(warnMessage);
            this._highThroughputCount = 0L;
        }
    }

    @Override
    public org.jboss.dashboard.annotation.Priority getPriority() {
        return org.jboss.dashboard.annotation.Priority.URGENT;
    }

    @Override
    public void start() throws Exception {
        this.createMemoryAppender();
        this.initCoreLoggerSets();
        this.initLoggerSets();
    }

    protected void createMemoryAppender() {
        this.memoryAppender = new MemoryAppender(this);
        this.memoryAppender.setName(this.memoryAppenderName);
        this.memoryAppender.setLayout((Layout)new PatternLayout(this.memoryAppenderPattern));
        this.memoryAppender.setBufferSize(this.memoryAppenderBufferSize);
        Logger.getRootLogger().addAppender((Appender)this.memoryAppender);
        Enumeration enumLoggers = LogManager.getCurrentLoggers();
        while (enumLoggers.hasMoreElements()) {
            Logger logger = (Logger)enumLoggers.nextElement();
            if (logger.getLevel() == null) continue;
            logger.addAppender((Appender)this.memoryAppender);
        }
    }

    protected void initCoreLoggerSets() {
        this.loggerSets = new ArrayList<LoggerSet>();
        this.loggerSets.add(LoggerSet.ROOT);
        Enumeration enumLoggers = LogManager.getCurrentLoggers();
        while (enumLoggers.hasMoreElements()) {
            Logger logger = (Logger)enumLoggers.nextElement();
            if (logger.getLevel() == null) continue;
            this.loggerSets.add(new LoggerSet(logger.getName(), logger, false));
        }
    }

    protected void initLoggerSets() {
        this.loggerSets.add(new LoggerSet("Transactions", Level.FATAL, "org.jboss.dashboard.database.hibernate.HibernateTransaction", false));
        this.loggerSets.add(new LoggerSet("SQL sentences", Level.FATAL, "org.jboss.dashboard.database.NonPooledDataSource", false));
        this.loggerSets.add(new LoggerSet("Hibernate SQL", Level.FATAL, "org.hibernate.engine.jdbc.internal\norg.hibernate.SQL\norg.hibernate.pretty", false));
        this.loggerSets.add(new LoggerSet("HTTP requests", Level.FATAL, "org.jboss.dashboard.ui.controller.ControllerServlet\norg.jboss.dashboard.ui.controller.responses", false));
    }
}

