/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.log;

import java.util.LinkedList;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.dashboard.log.Log4JManager;

public class MemoryAppender
extends AppenderSkeleton {
    protected int bufferSize;
    protected transient LinkedList<LoggingEvent> buffer;
    protected transient Log4JManager log4JManager;
    protected transient boolean _onAppend;

    public MemoryAppender(Log4JManager log4JManager) {
        this.log4JManager = log4JManager;
        this.name = "MEMORY";
        this.buffer = new LinkedList();
        this.bufferSize = 10000;
        this._onAppend = false;
    }

    public LinkedList<LoggingEvent> getBuffer() {
        return this.buffer;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
    }

    public void close() {
    }

    public synchronized void clear() {
        this.buffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void append(LoggingEvent event) {
        if (this._onAppend) {
            return;
        }
        this.buffer.addLast(event);
        if (this.buffer.size() > this.bufferSize) {
            this.buffer.removeFirst();
        }
        try {
            this._onAppend = true;
            this.log4JManager.onAppend(event);
        }
        finally {
            this._onAppend = false;
        }
    }
}

