/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.dashboard.commons.misc.Chronometer;
import org.jboss.dashboard.error.ErrorReport;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.CodeBlockTraces;
import org.jboss.dashboard.profiler.CodeBlockType;
import org.jboss.dashboard.profiler.CoreCodeBlockTypes;
import org.jboss.dashboard.profiler.Profiler;
import org.jboss.dashboard.profiler.StackTrace;
import org.jboss.dashboard.profiler.TimeTrace;

public class ThreadProfile {
    private static transient Log log = LogFactory.getLog((String)ThreadProfile.class.getName());
    protected String id;
    protected Date beginDate;
    protected Date endDate;
    protected Thread thread;
    protected CodeBlockTrace rootCodeBlock;
    protected CodeBlockTrace codeBlockInProgress;
    protected List<StackTrace> stackTraces = new ArrayList<StackTrace>();
    protected long maxThreadDurationInMillis = 120000L;
    protected int maxStackTraceLength = 500;
    protected boolean elapsedTimeExceeded;
    protected boolean stackTraceTooLarge;
    protected int largeStackTracesCount;
    protected Map<String, Object> contextProperties = Collections.synchronizedMap(new LinkedHashMap());
    protected static List<String> contextPropertyNames = new ArrayList<String>();
    protected List<LogEvent> logEvents = null;
    protected int maxLogEvents = 10000;
    protected transient boolean logOverflow = false;
    protected ErrorReport errorReport = null;
    protected boolean targetThread = false;
    public static final String THREAD_ID = "Thread id";
    public static final String THREAD_BEGIN_DATE = "Thread begin date";
    public static final String THREAD_GROUP = "Thread group";
    public static final String USER_LOGIN = "User login";
    public static final String USER_NAME = "User name";
    public static final String STATE_ERROR = "ERROR";
    public static final String STATE_COMPLETED = "COMPLETED";

    public ThreadProfile() {
        this.clearStackTraces();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public long getElapsedTime() {
        long endTime = this.endDate != null ? this.endDate.getTime() : System.currentTimeMillis();
        return endTime - this.beginDate.getTime();
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    public long getMaxThreadDurationInMillis() {
        return this.maxThreadDurationInMillis;
    }

    public void setMaxThreadDurationInMillis(long maxThreadDurationInMillis) {
        this.maxThreadDurationInMillis = maxThreadDurationInMillis;
    }

    public int getMaxStackTraceLength() {
        return this.maxStackTraceLength;
    }

    public void setMaxStackTraceLength(int maxStackTraceLength) {
        this.maxStackTraceLength = maxStackTraceLength;
    }

    public boolean isElapsedTimeExceeded() {
        return this.elapsedTimeExceeded;
    }

    public boolean isStackTraceTooLarge() {
        return this.stackTraceTooLarge;
    }

    public CodeBlockTrace getCodeBlockInProgress() {
        return this.codeBlockInProgress;
    }

    public CodeBlockTrace getRootCodeBlock() {
        return this.rootCodeBlock;
    }

    public int getMaxLogEvents() {
        return this.maxLogEvents;
    }

    public void setMaxLogEvents(int maxLogEvents) {
        this.maxLogEvents = maxLogEvents;
    }

    public ErrorReport getErrorReport() {
        return this.errorReport;
    }

    public void setErrorReport(ErrorReport errorReport) {
        this.errorReport = errorReport;
        if (errorReport != null) {
            errorReport.setCodeBlock(this.codeBlockInProgress);
        }
    }

    public String getState() {
        if (this.isRunning()) {
            return this.thread.getState().toString();
        }
        if (this.errorReport != null) {
            return STATE_ERROR;
        }
        return STATE_COMPLETED;
    }

    public void addContextProperty(String propName, Object propValue) {
        if (propName == null) {
            return;
        }
        if (!contextPropertyNames.contains(propName)) {
            contextPropertyNames.add(propName);
        }
        this.contextProperties.put(propName, propValue);
    }

    public void addContextProperties(Map<String, Object> props) {
        for (String propName : props.keySet()) {
            if (propName == null) continue;
            this.addContextProperty(propName, props.get(propName));
        }
    }

    public Object getContextProperty(String propName) {
        return this.contextProperties.get(propName);
    }

    public Set<String> getContextPropertyNames() {
        return this.contextProperties.keySet();
    }

    public static List<String> getAllContextPropertyNames() {
        return Collections.unmodifiableList(contextPropertyNames);
    }

    public boolean isTargetThread() {
        return this.targetThread;
    }

    public void setTargetThread(boolean targetThread) {
        this.targetThread = targetThread;
    }

    public void begin() {
        this.id = Thread.currentThread().getName();
        this.thread = Thread.currentThread();
        this.beginDate = new Date();
        this.endDate = null;
        this.codeBlockInProgress = null;
        this.rootCodeBlock = new RootTrace(this.thread, this.beginDate);
        this.rootCodeBlock.begin();
    }

    public void end() {
        this.endDate = new Date();
        this.rootCodeBlock.end();
        this.thread = null;
    }

    public static String printStackTrace(Thread t, int lines) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("'" + t.getName() + "' '" + t.getState().toString() + "' ");
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < trace.length && i < lines; ++i) {
            pw.println("\tat " + trace[i]);
        }
        return sw.toString();
    }

    public String printContext() {
        StringBuffer buf = new StringBuffer();
        if (this.codeBlockInProgress != null) {
            buf.append(this.codeBlockInProgress.printContext(true));
        }
        buf.append("\nElapsed time=").append(Chronometer.formatElapsedTime(this.getElapsedTime()));
        if (this.isRunning()) {
            buf.append("\nCaller thread: ").append(ThreadProfile.printStackTrace(this.getThread(), 9999));
        }
        return buf.toString();
    }

    public synchronized int getNumberOfSamples() {
        return this.stackTraces.size();
    }

    public synchronized long getSampleAverageTimeMillis() {
        if (this.stackTraces.size() == 0) {
            return 0L;
        }
        return this.getProfileTimeMillis() / (long)this.stackTraces.size();
    }

    public synchronized void clearStackTraces() {
        this.stackTraces.clear();
        this.elapsedTimeExceeded = false;
        this.stackTraceTooLarge = false;
        this.largeStackTracesCount = 0;
    }

    public synchronized void dumpStackTrace() {
        if (this.elapsedTimeExceeded || this.stackTraceTooLarge) {
            return;
        }
        StackTrace st = new StackTrace(this.thread.getStackTrace(), this.codeBlockInProgress);
        this.stackTraces.add(st);
        if (this.getProfileTimeMillis() > this.maxThreadDurationInMillis) {
            this.elapsedTimeExceeded = true;
        }
        if (st.length() > this.maxStackTraceLength) {
            ++this.largeStackTracesCount;
            this.stackTraceTooLarge = this.largeStackTracesCount > 5;
        } else {
            this.largeStackTracesCount = 0;
        }
    }

    public synchronized long getProfileTimeMillis() {
        if (this.stackTraces.isEmpty() || this.stackTraces.size() == 1) {
            return 0L;
        }
        StackTrace first = this.stackTraces.get(0);
        StackTrace last = this.stackTraces.get(this.stackTraces.size() - 1);
        return last.getCreationTimeMillis() - first.getCreationTimeMillis();
    }

    public synchronized List<TimeTrace> calculateTimeTraces() {
        List<TimeTrace> traces = this.calculateTimeTraces(0, this.stackTraces.size(), 0);
        if (traces == null) {
            return null;
        }
        ArrayList<TimeTrace> timeTraces = new ArrayList<TimeTrace>();
        this.toPlainList(traces, timeTraces);
        CodeBlockTraces codeTraces = this.rootCodeBlock.toPlainList();
        for (int codeIndex = 0; codeIndex < codeTraces.size(); ++codeIndex) {
            CodeBlockTrace codeTrace = codeTraces.get(codeIndex);
            boolean added = false;
            for (int traceIndex = timeTraces.size() - 1; traceIndex >= 0 && !added; --traceIndex) {
                TimeTrace timeTrace = (TimeTrace)timeTraces.get(traceIndex);
                if (codeTrace.getBeginTimeMillis() < timeTrace.getBeginTimeMillis() || codeTrace.getEndTimeMillis() > timeTrace.getEndTimeMillis()) continue;
                timeTrace.getCodeBlockTraces().add(codeTrace);
                added = true;
            }
            if (added || !log.isDebugEnabled()) continue;
            log.debug((Object)("Time trace not found for code block.\n" + codeTrace.toString()));
        }
        return traces;
    }

    protected List<TimeTrace> calculateTimeTraces(int sampleStart, int sampleEnd, int stackLevel) {
        if (this.stackTraces == null || this.stackTraces.size() < 2) {
            return null;
        }
        ArrayList<TimeTrace> results = new ArrayList<TimeTrace>();
        int newTraceStart = -1;
        for (int i = sampleStart + 1; i < sampleEnd; ++i) {
            StackTrace previous = this.stackTraces.get(i - 1);
            StackTrace current = this.stackTraces.get(i);
            StackTraceElement prevEl = previous.get(stackLevel);
            StackTraceElement currEl = current.get(stackLevel);
            if (prevEl != null && prevEl.equals(currEl)) {
                if (newTraceStart != -1) continue;
                newTraceStart = i - 1;
                continue;
            }
            if (newTraceStart == -1) continue;
            TimeTrace newStackTrace = this.createTimeTrace(newTraceStart, i, stackLevel);
            results.add(newStackTrace);
            newTraceStart = -1;
        }
        if (newTraceStart != -1) {
            TimeTrace newStackTrace = this.createTimeTrace(newTraceStart, sampleEnd, stackLevel);
            results.add(newStackTrace);
        }
        return results;
    }

    protected TimeTrace createTimeTrace(int traceStart, int traceEnd, int stackLevel) {
        int stackLength = stackLevel + 1;
        boolean stop = false;
        while (!stop) {
            StackTrace first = this.stackTraces.get(traceStart);
            StackTraceElement firstEl = first.get(stackLength);
            for (int i = traceStart + 1; i < traceEnd && !stop; ++i) {
                StackTrace current = this.stackTraces.get(i);
                StackTraceElement currEl = current.get(stackLength);
                if (firstEl != null && firstEl.equals(currEl)) continue;
                stop = true;
            }
            if (stop) continue;
            ++stackLength;
        }
        StackTraceElement[] trace = this.stackTraces.get(traceStart).from(0, stackLength);
        ArrayList<StackTrace> samples = new ArrayList<StackTrace>(this.stackTraces.subList(traceStart, traceEnd));
        List<TimeTrace> children = this.calculateTimeTraces(traceStart, traceEnd, stackLength);
        return new TimeTrace(trace, samples, children, null);
    }

    protected void toPlainList(List<TimeTrace> traces, List<TimeTrace> results) {
        if (traces.isEmpty()) {
            return;
        }
        results.addAll(traces);
        for (TimeTrace trace : traces) {
            this.toPlainList(trace.getChildren(), results);
        }
    }

    public void addLog4JEvent(LoggingEvent event) {
        this.addLogEvent(new Log4JEvent(this.codeBlockInProgress, event));
    }

    public void addCodeBlockBeginEvent(CodeBlockTrace trace) {
        this.addLogEvent(new CodeBlockBeginEvent(trace));
    }

    public void addCodeBlockEndEvent(CodeBlockTrace trace) {
        this.addLogEvent(new CodeBlockEndEvent(trace));
    }

    public void addLogEvent(LogEvent event) {
        if (this.logEvents == null) {
            this.logEvents = new ArrayList<LogEvent>();
        }
        this.logEvents.add(event);
        if (this.logOverflow) {
            this.logEvents.remove(1);
        } else {
            this.logOverflow = this.logEvents.size() > this.maxLogEvents;
            if (this.logOverflow) {
                this.logEvents.add(0, this.createLogOverflowMessage());
            }
        }
    }

    protected MessageEvent createLogOverflowMessage() {
        return new MessageEvent(this.codeBlockInProgress, "\n! AVOID MEMORY OVERFLOW. ONLY THE LOW " + this.maxLogEvents + " EVENTS RECORDED !\n");
    }

    public List<LogEvent> getLogEvents(boolean includeCodeBlockEvents, boolean removeCodeBlocksWithoutLogs) {
        if (this.logEvents == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LogEvent> result = new ArrayList<LogEvent>(this.logEvents);
        if (!includeCodeBlockEvents) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                LogEvent event = (LogEvent)it.next();
                if (event instanceof Log4JEvent) continue;
                it.remove();
            }
        } else if (removeCodeBlocksWithoutLogs) {
            int index = 0;
            while (index < result.size()) {
                if (!(result.get(index++) instanceof CodeBlockBeginEvent) || index >= result.size() || !(result.get(index) instanceof CodeBlockEndEvent)) continue;
                result.remove(index--);
                result.remove(index--);
                if (index >= 0) continue;
                index = 0;
            }
        } else {
            return Collections.unmodifiableList(this.logEvents);
        }
        return result;
    }

    public static class MessageEvent
    extends LogEvent {
        protected String message;

        private MessageEvent(CodeBlockTrace codeBlockTrace, String message) {
            super(codeBlockTrace, System.currentTimeMillis());
            this.message = message;
        }

        @Override
        public String format(Map<String, Object> props) {
            return this.message;
        }
    }

    public static class Log4JEvent
    extends LogEvent {
        public static final String LAYOUT = "layout";
        LoggingEvent log4jEvent;

        private Log4JEvent(CodeBlockTrace codeBlockTrace, LoggingEvent log4jEvent) {
            super(codeBlockTrace, log4jEvent.getTimeStamp());
            this.log4jEvent = log4jEvent;
        }

        @Override
        public String format(Map<String, Object> props) {
            Layout layout = (Layout)props.get(LAYOUT);
            return layout.format(this.log4jEvent);
        }
    }

    public static class CodeBlockEndEvent
    extends LogEvent {
        public CodeBlockEndEvent(CodeBlockTrace trace) {
            super(trace, trace.getEndTimeMillis());
        }

        @Override
        public String format(Map<String, Object> props) {
            String traceTime = Chronometer.formatElapsedTime(this.codeBlockTrace.getElapsedTimeMillis());
            String traceStr = this.codeBlockTrace.getType().getId() + " - " + this.codeBlockTrace.getDescription() + " - " + traceTime + "\n";
            return "END " + traceStr;
        }
    }

    public static class CodeBlockBeginEvent
    extends LogEvent {
        public CodeBlockBeginEvent(CodeBlockTrace trace) {
            super(trace, trace.getBeginTimeMillis());
        }

        @Override
        public String format(Map<String, Object> props) {
            String traceTime = Chronometer.formatElapsedTime(this.codeBlockTrace.getElapsedTimeMillis());
            String traceStr = this.codeBlockTrace.getType().getId() + " - " + this.codeBlockTrace.getDescription() + " - " + traceTime + "\n";
            return "BEGIN " + traceStr;
        }
    }

    public static abstract class LogEvent {
        CodeBlockTrace codeBlockTrace;
        long timestamp;

        protected LogEvent(CodeBlockTrace trace, long timestamp) {
            this.codeBlockTrace = trace;
            this.timestamp = timestamp;
        }

        public CodeBlockTrace getCodeBlockTrace() {
            return this.codeBlockTrace;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public abstract String format(Map<String, Object> var1);
    }

    static class RootTrace
    extends CodeBlockTrace {
        protected String group;
        protected String state;
        protected Date beginDate;
        protected Map<String, Object> context;

        public RootTrace(Thread thread, Date beginDate) {
            super(thread.getName());
            this.beginDate = beginDate;
            this.state = thread.getState().toString();
            this.group = thread.getThreadGroup().getName();
            this.context = this.buildContext();
        }

        @Override
        public CodeBlockType getType() {
            return CoreCodeBlockTypes.THREAD;
        }

        @Override
        public String getDescription() {
            return this.id;
        }

        @Override
        public Map<String, Object> getContext() {
            return this.context;
        }

        protected Map<String, Object> buildContext() {
            LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
            ctx.put(ThreadProfile.THREAD_ID, this.id);
            ctx.put(ThreadProfile.THREAD_BEGIN_DATE, this.beginDate);
            ctx.put(ThreadProfile.THREAD_GROUP, this.group);
            ThreadProfile threadProfile = Profiler.lookup().getCurrentThreadProfile();
            if (threadProfile != null) {
                threadProfile.addContextProperties(ctx);
            }
            return ctx;
        }
    }
}

