/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.util.Hashtable;
import java.util.Set;
import org.jboss.dashboard.factory.ComponentsStorage;
import org.jboss.dashboard.factory.GlobalComponentsStorage;
import org.jboss.dashboard.factory.LookupHelper;
import org.jboss.dashboard.factory.VolatileComponentsStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentsContextManager {
    private static transient Logger log = LoggerFactory.getLogger((String)ComponentsContextManager.class.getName());
    private static ThreadLocal thr = new ThreadLocal();
    private static Hashtable availableContexts = new Hashtable();

    public static void addComponentStorage(String scope, ComponentsStorage storage) {
        availableContexts.put(scope, storage);
    }

    public static void startContext() {
        if (thr.get() == null) {
            thr.set(ComponentsContextManager.createLookupHelper());
        } else {
            Exception e = new Exception();
            log.error("Error starting context. Context already started, and nested contexts are not supported.", (Throwable)e);
        }
    }

    public static boolean isContextStarted() {
        return thr.get() != null;
    }

    protected static LookupHelper createLookupHelper() {
        LookupHelper helper = new LookupHelper();
        Set contexts = availableContexts.keySet();
        for (String scope : contexts) {
            ComponentsStorage storage = (ComponentsStorage)availableContexts.get(scope);
            helper.addStorageResolver(scope, storage);
        }
        return helper;
    }

    public static LookupHelper getLookupHelper() {
        LookupHelper helper = (LookupHelper)thr.get();
        if (helper == null) {
            log.error("Cannot perform Factory operations outside a valid context. You must enclose all your Factory operations within a Factory.doWork() operation.");
        }
        return helper;
    }

    public static void clearContext() {
        if (thr.get() != null) {
            LookupHelper helper = (LookupHelper)thr.get();
            helper.clear();
            thr.set(null);
        } else {
            log.error("Error clearing context. Context was not started.");
        }
    }

    static {
        availableContexts.put("global", new GlobalComponentsStorage());
        availableContexts.put("volatile", new VolatileComponentsStorage());
    }
}

