/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.factory.BasicFactoryElement;
import org.jboss.dashboard.factory.ComponentsContextManager;
import org.jboss.dashboard.factory.ComponentsTree;
import org.jboss.dashboard.factory.FactoryLifecycle;
import org.jboss.dashboard.factory.LookupException;
import org.jboss.dashboard.factory.LookupHelper;
import org.jboss.dashboard.factory.PropertyAddProcessingInstruction;
import org.jboss.dashboard.factory.PropertyChangeProcessingInstruction;
import org.jboss.dashboard.factory.PropertySetProcessingInstruction;
import org.jboss.dashboard.factory.PropertySubstractProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Component {
    private static transient Logger log = LoggerFactory.getLogger((String)Component.class.getName());
    public static final String ALIAS_PROPERTY = "alias";
    public static final String CLASS_PROPERTY = "class";
    public static final String SCOPE_PROPERTY = "scope";
    public static final String DESC_PROPERTY = "description";
    public static final String ENABLED_PROPERTY = "enabled";
    public static final String SPECIAL_PROPERTY_PREFFIX = "$";
    public static final String SCOPE_GLOBAL = "global";
    public static final String SCOPE_SESSION = "session";
    public static final String SCOPE_PANEL_SESSION = "panelSession";
    public static final String SCOPE_REQUEST = "request";
    public static final String SCOPE_VOLATILE = "volatile";
    public final List VALID_SCOPES;
    public static final int STATUS_INCOMPLETE = 0;
    public static final int STATUS_VALID = 1;
    public static final int STATUS_INVALID = -1;
    private int status = 0;
    private String name;
    private ComponentsTree tree;
    private String description;
    private String clazz;
    private String scope;
    private String alias;
    private boolean enabled = true;
    private Class componentClass;
    private Map componentConfiguredProperties = new Hashtable();
    private List propertiesFilesAdded = new ArrayList();
    private long creationOrderNumber;

    public long getCreationOrderNumber() {
        return this.creationOrderNumber;
    }

    public void setCreationOrderNumber(long creationOrderNumber) {
        this.creationOrderNumber = creationOrderNumber;
    }

    public Component(String name, ComponentsTree tree) {
        this.name = name;
        this.tree = tree;
        this.VALID_SCOPES = Collections.unmodifiableList(this.getInitScopes());
    }

    public ComponentsTree getTree() {
        return this.tree;
    }

    protected List getInitScopes() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(SCOPE_GLOBAL);
        l.add(SCOPE_SESSION);
        l.add(SCOPE_PANEL_SESSION);
        l.add(SCOPE_REQUEST);
        l.add(SCOPE_VOLATILE);
        return l;
    }

    public Map getComponentConfiguredProperties() {
        return this.componentConfiguredProperties;
    }

    void addProperties(Properties properties, String fileName) {
        String declaredClass = properties.getProperty("$class");
        String declaredScope = properties.getProperty("$scope");
        String declaredDescr = properties.getProperty("$description");
        String declaredEnabled = properties.getProperty("$enabled");
        String declaredAlias = properties.getProperty("$alias");
        if (declaredClass != null && this.clazz != null) {
            try {
                Class<?> currentClass = Class.forName(this.clazz);
                Class<?> newClass = Class.forName(declaredClass);
                if (!currentClass.isAssignableFrom(newClass)) {
                    log.warn("Assigning class " + declaredClass + " to component " + this.name + " may cause errors. " + "Default system class is " + this.clazz + ", new class is not descendant.");
                }
            }
            catch (ClassNotFoundException e) {
                log.error("Error:", (Throwable)e);
            }
        }
        this.clazz = declaredClass == null ? this.clazz : declaredClass;
        this.alias = declaredAlias == null ? this.alias : declaredAlias;
        this.scope = declaredScope == null ? this.scope : declaredScope;
        this.description = declaredDescr == null ? this.description : declaredDescr;
        this.enabled = declaredEnabled == null ? this.enabled : Boolean.valueOf(declaredEnabled);
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String propertyName = (String)en.nextElement();
            if (propertyName.startsWith(SPECIAL_PROPERTY_PREFFIX)) continue;
            if (!this.isValidPropertyName(propertyName)) {
                log.error("Ignoring invalid property name " + propertyName + " in component " + this.name);
                continue;
            }
            String propertyValue = properties.getProperty(propertyName);
            this.storeProperty(propertyName, propertyValue);
        }
        this.propertiesFilesAdded.add(fileName);
    }

    protected boolean isValidPropertyName(String propertyName) {
        char c;
        if (propertyName == null || propertyName.length() == 0) {
            return false;
        }
        if (propertyName.endsWith("-") || propertyName.endsWith("+")) {
            propertyName = propertyName.substring(0, propertyName.length() - 1);
        }
        if (propertyName.length() == 0) {
            return false;
        }
        for (int i = 0; i < propertyName.length() && '.' != (c = propertyName.charAt(i)); ++i) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    protected void storeProperty(String propertyName, String propertyValue) {
        ArrayList<PropertySetProcessingInstruction> currentValue = null;
        PropertyChangeProcessingInstruction instruction = null;
        if (propertyName.endsWith("+")) {
            propertyName = propertyName.substring(0, propertyName.length() - 1).trim();
            instruction = new PropertyAddProcessingInstruction(this, propertyName, propertyValue);
        } else if (propertyName.endsWith("-")) {
            propertyName = propertyName.substring(0, propertyName.length() - 1).trim();
            instruction = new PropertySubstractProcessingInstruction(this, propertyName, propertyValue);
        } else {
            instruction = new PropertySetProcessingInstruction(this, propertyName, propertyValue);
        }
        currentValue = (ArrayList<PropertySetProcessingInstruction>)this.componentConfiguredProperties.get(propertyName);
        if (currentValue == null) {
            currentValue = new ArrayList<PropertySetProcessingInstruction>();
        }
        currentValue.add((PropertySetProcessingInstruction)instruction);
        this.componentConfiguredProperties.put(propertyName, currentValue);
    }

    public void setProperty(String propertyName, String[] propertyValues) throws Exception {
        StringBuffer propertyValue = new StringBuffer();
        for (int i = 0; i < propertyValues.length; ++i) {
            String value = propertyValues[i];
            if (i != 0) {
                propertyValue.append(",");
            }
            if (propertyValues.length > 1) {
                propertyValue.append(StringUtils.replace((String)value, (String)",", (String)",,"));
                continue;
            }
            propertyValue.append(value);
        }
        ArrayList<PropertySetProcessingInstruction> list = new ArrayList<PropertySetProcessingInstruction>();
        list.add(new PropertySetProcessingInstruction(this, propertyName, propertyValue.toString()));
        this.setObjectProperty(this.getObject(), propertyName, list, null);
    }

    public void setProperty(String propertyName, File propertyValue) throws Exception {
        Object obj = this.getObject();
        Field field = this.getField(obj, propertyName);
        if (field != null) {
            Class<?> fieldClass = field.getType();
            if (File.class.equals(fieldClass)) {
                if (log.isDebugEnabled()) {
                    log.debug("Invoking field " + propertyName + " with file.");
                }
                field.set(obj, propertyValue);
            } else if (byte[].class.equals(fieldClass)) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(propertyValue));
                int byteRead = -1;
                while ((byteRead = bis.read()) != -1) {
                    bos.write(byteRead);
                }
                bis.close();
                bos.close();
                if (log.isDebugEnabled()) {
                    log.debug("Invoking field " + propertyName + " with byte[].");
                }
                field.set(obj, bos.toByteArray());
            } else {
                log.error("Cannot write a file to property " + propertyName + " in bean " + this.name);
            }
            return;
        }
        Method getter = this.getGetter(obj, propertyName);
        if (getter == null) {
            log.error("Cannot find a getter for property " + propertyName + " in class " + this.clazz + ". Ignoring property.");
            return;
        }
        Method setter = this.getSetter(obj, getter, propertyName);
        if (setter == null) {
            log.error("Cannot find a setter for property " + propertyName + " in class " + this.clazz + ". Ignoring property.");
            return;
        }
        Class<?> returnType = getter.getReturnType();
        if (File.class.equals(returnType)) {
            if (log.isDebugEnabled()) {
                log.debug("Invoking " + setter + " with file.");
            }
            setter.invoke(obj, propertyValue);
        } else if (byte[].class.equals(returnType)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(propertyValue));
            int byteRead = -1;
            while ((byteRead = bis.read()) != -1) {
                bos.write(byteRead);
            }
            bis.close();
            bos.close();
            if (log.isDebugEnabled()) {
                log.debug("Invoking " + setter + " with byte[].");
            }
            setter.invoke(obj, new Object[]{bos.toByteArray()});
        } else {
            log.error("Cannot write a file to property " + propertyName + " in bean " + this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getScope() {
        return this.scope;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDescription() {
        return this.description;
    }

    public List getPropertiesFilesAdded() {
        return Collections.unmodifiableList(this.propertiesFilesAdded);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.scope).append(" Component named ").append(this.name).append(" with class ").append(this.clazz).append(" and params " + this.componentConfiguredProperties);
        return sb.toString();
    }

    public void validate() {
        if (!this.VALID_SCOPES.contains(this.scope)) {
            log.error("Invalid scope " + this.scope + " for component " + this.name + "");
            this.status = -1;
            return;
        }
        try {
            this.componentClass = Class.forName(this.clazz);
        }
        catch (Throwable e) {
            log.error("Invalid class for component " + this.name + ": " + this.clazz, e);
            this.status = -1;
            return;
        }
        this.status = 1;
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws LookupException {
        if (!this.enabled) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Getting " + this.scope + " component " + this.name);
        }
        if (this.status != -1) {
            LookupHelper helper = ComponentsContextManager.getLookupHelper();
            Object object = helper.getSynchronizationObject(this.getScope());
            synchronized (object) {
                if (this.getTheInstance() == null) {
                    return this.makeAndSetNewInstance();
                }
            }
            return this.getTheInstance();
        }
        log.warn("Component " + this.name + " is in invalid status.");
        return null;
    }

    protected final Object getTheInstance() throws LookupException {
        LookupHelper helper = ComponentsContextManager.getLookupHelper();
        if (helper != null) {
            return helper.lookupObject(this.scope, this.name);
        }
        throw new LookupException("Cannot get " + this.getName() + ". Factory operation is outside a valid context.");
    }

    protected final void setTheInstance(Object instance) {
        LookupHelper helper = ComponentsContextManager.getLookupHelper();
        if (helper != null) {
            helper.storeObject(this.scope, this.name, instance);
        } else {
            log.error("Cannot set " + this.getName() + ". Factory operation is outside a valid context.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object makeAndSetNewInstance() {
        LookupHelper helper = ComponentsContextManager.getLookupHelper();
        Object object = helper.getSynchronizationObject(this.getScope());
        synchronized (object) {
            Object object2 = null;
            if (this.status == 1) {
                block24: {
                    if (log.isDebugEnabled()) {
                        log.debug("Making and initializing new " + this.clazz);
                    }
                    if (this.scope.equals(SCOPE_GLOBAL)) {
                        try {
                            object2 = this.componentClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block24;
                            log.debug("Error using getInstance() method on " + this.clazz);
                        }
                    }
                }
                if (object2 == null) {
                    try {
                        object2 = this.componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        log.error("Error creating instance for component " + this.name + " :", (Throwable)e);
                    }
                }
                if (object2 == null) {
                    this.status = -1;
                    log.error("Make sure the component class has a default public constructor" + (this.scope.equals(SCOPE_GLOBAL) ? ", or a static getInstance() method." : "."));
                } else {
                    if (object2 instanceof FactoryLifecycle) {
                        try {
                            if (object2 instanceof BasicFactoryElement) {
                                ((BasicFactoryElement)object2).setComponentName(this.name);
                                ((BasicFactoryElement)object2).setComponentScope(this.scope);
                                ((BasicFactoryElement)object2).setComponentDescription(this.description);
                                ((BasicFactoryElement)object2).setComponentAlias(this.alias);
                            }
                            ((FactoryLifecycle)object2).init();
                            ((FactoryLifecycle)object2).stop();
                        }
                        catch (Exception e) {
                            log.error("Error in component lifecycle ", (Throwable)e);
                        }
                    }
                    this.setTheInstance(object2);
                    JXPathContext ctx = JXPathContext.newContext((Object)object2);
                    for (String propertyName : this.componentConfiguredProperties.keySet()) {
                        List propertyValue = (List)this.componentConfiguredProperties.get(propertyName);
                        try {
                            this.setObjectProperty(object2, propertyName, propertyValue, ctx);
                        }
                        catch (Exception e) {
                            log.error("Error. Cannot set property " + this.getName() + "." + propertyName + " with configured values " + propertyValue, (Throwable)e);
                        }
                    }
                    this.status = 1;
                    if (object2 instanceof FactoryLifecycle) {
                        try {
                            ((FactoryLifecycle)object2).start();
                        }
                        catch (Exception e) {
                            log.error("Error in component lifecycle ", (Throwable)e);
                        }
                    }
                    this.setCreationOrderNumber(this.getTree().getNewOrderCounter());
                }
            } else {
                log.error("Infinite loop detected. Caused by component " + this.name + " or some other component used by it.");
            }
            return object2;
        }
    }

    protected Object setObjectProperty(Object obj, String propertyName, List propertyValue, JXPathContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Setting in " + this.clazz + " property " + propertyName + " with values " + propertyValue);
        }
        if (obj instanceof Map) {
            ((Map)obj).put(propertyName, this.getValueForProperty(propertyValue, String.class));
        } else if (obj instanceof List) {
            try {
                int index = Integer.parseInt(propertyName);
                while (((List)obj).size() <= index) {
                    ((List)obj).add(null);
                }
                ((List)obj).set(index, this.getValueForProperty(propertyValue, String.class));
            }
            catch (Exception e) {
                log.error("Error setting position " + propertyName + " in List " + this.name + ". ", (Throwable)e);
            }
        } else if (propertyName.indexOf(46) != -1) {
            ctx = ctx != null ? ctx : JXPathContext.newContext((Object)obj);
            ctx.setValue(propertyName.replace('.', '/'), this.getValueForProperty(propertyValue, String.class));
        } else {
            Field field = this.getField(obj, propertyName);
            if (field != null) {
                Class<?> fieldClass = field.getType();
                Object value = this.getValueForProperty(propertyValue, fieldClass);
                field.set(obj, value);
                return obj;
            }
            Method getter = this.getGetter(obj, propertyName);
            if (getter == null) {
                log.error("Cannot find a getter for property " + propertyName + " in class " + this.clazz + ". Ignoring property.");
                return obj;
            }
            Method setter = this.getSetter(obj, getter, propertyName);
            if (setter == null) {
                log.error("Cannot find a setter for property " + propertyName + " in class " + this.clazz + ". Ignoring property.");
                return obj;
            }
            Object value = this.getValueForProperty(propertyValue, getter.getReturnType());
            if (log.isDebugEnabled()) {
                log.debug("Invoking " + setter + " with value=" + value);
            }
            setter.invoke(obj, value);
        }
        return obj;
    }

    protected Field getField(Object obj, String propertyName) {
        try {
            Field field = obj.getClass().getField(propertyName);
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isFinal(field.getModifiers())) {
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug("Could not find a field for property " + propertyName + " in " + obj.getClass());
        }
        return null;
    }

    protected Method getGetter(Object obj, String propertyName) {
        Method getter = null;
        String propertyAccessorSuffix = StringUtils.capitalize((String)propertyName);
        String getterName = "get" + propertyAccessorSuffix;
        try {
            getter = obj.getClass().getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.debug("No getter " + getterName + " found.");
            String booleanGetterName = "is" + propertyAccessorSuffix;
            try {
                getter = obj.getClass().getMethod(booleanGetterName, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                log.debug("No getter " + booleanGetterName + " found.");
            }
        }
        return getter;
    }

    protected Method getSetter(Object obj, Method getter, String propertyName) {
        Method setter = null;
        String propertyAccessorSuffix = StringUtils.capitalize((String)propertyName);
        String setterName = "set" + propertyAccessorSuffix;
        Class<?> returnType = getter.getReturnType();
        try {
            setter = obj.getClass().getMethod(setterName, returnType);
        }
        catch (NoSuchMethodException e) {
            log.error("Cannot find a setter for property " + propertyName + " in class " + this.clazz + ". Ignoring property.");
        }
        return setter;
    }

    protected Object getValueForProperty(List values, Class expectedClass) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Converting to " + expectedClass + " values " + values);
        }
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object valueToReturn = null;
        for (int i = 0; i < values.size(); ++i) {
            PropertyChangeProcessingInstruction instruction = (PropertyChangeProcessingInstruction)values.get(i);
            valueToReturn = instruction.getValueAfterChange(valueToReturn, expectedClass);
        }
        if (expectedClass.isArray() && expectedClass.getComponentType().isPrimitive() && valueToReturn != null) {
            if (expectedClass.getComponentType().equals(Integer.TYPE)) {
                int[] newValueToReturn = new int[((Object[])valueToReturn).length];
                int i = 0;
                while (i < newValueToReturn.length) {
                    newValueToReturn[i] = (Integer)((Object[])valueToReturn)[i++];
                }
                return newValueToReturn;
            }
            if (expectedClass.getComponentType().equals(Boolean.TYPE)) {
                boolean[] newValueToReturn = new boolean[((Object[])valueToReturn).length];
                int i = 0;
                while (i < newValueToReturn.length) {
                    newValueToReturn[i] = (Boolean)((Object[])valueToReturn)[i++];
                }
                return newValueToReturn;
            }
            if (expectedClass.getComponentType().equals(Long.TYPE)) {
                long[] newValueToReturn = new long[((Object[])valueToReturn).length];
                int i = 0;
                while (i < newValueToReturn.length) {
                    newValueToReturn[i] = (Long)((Object[])valueToReturn)[i++];
                }
                return newValueToReturn;
            }
            if (expectedClass.getComponentType().equals(Character.TYPE)) {
                char[] newValueToReturn = new char[((Object[])valueToReturn).length];
                int i = 0;
                while (i < newValueToReturn.length) {
                    newValueToReturn[i] = ((Character)((Object[])valueToReturn)[i++]).charValue();
                }
                return newValueToReturn;
            }
            if (expectedClass.getComponentType().equals(Double.TYPE)) {
                double[] newValueToReturn = new double[((Object[])valueToReturn).length];
                int i = 0;
                while (i < newValueToReturn.length) {
                    newValueToReturn[i] = (Double)((Object[])valueToReturn)[i++];
                }
                return newValueToReturn;
            }
            if (expectedClass.getComponentType().equals(Float.TYPE)) {
                float[] newValueToReturn = new float[((Object[])valueToReturn).length];
                int i = 0;
                while (i < newValueToReturn.length) {
                    newValueToReturn[i] = ((Float)((Object[])valueToReturn)[i++]).floatValue();
                }
                return newValueToReturn;
            }
            if (expectedClass.getComponentType().equals(Byte.TYPE)) {
                byte[] newValueToReturn = new byte[((Object[])valueToReturn).length];
                int i = 0;
                while (i < newValueToReturn.length) {
                    newValueToReturn[i] = (Byte)((Object[])valueToReturn)[i++];
                }
                return newValueToReturn;
            }
            if (expectedClass.getComponentType().equals(Short.TYPE)) {
                short[] newValueToReturn = new short[((Object[])valueToReturn).length];
                int i = 0;
                while (i < newValueToReturn.length) {
                    newValueToReturn[i] = (Short)((Object[])valueToReturn)[i++];
                }
                return newValueToReturn;
            }
        }
        return valueToReturn;
    }
}

