/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.jboss.dashboard.factory.Factory;
import org.jboss.dashboard.factory.FactoryLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicFactoryElement
implements FactoryLifecycle,
Serializable {
    private static transient Logger log = LoggerFactory.getLogger((String)BasicFactoryElement.class.getName());
    private String factoryComponentName;
    private String factoryComponentScope;
    private String factoryComponentDescription;
    private String factoryComponentAlias;
    private boolean componentKillFlag = false;

    @Override
    public void init() throws Exception {
        log.debug("Init for component " + this.getComponentName());
    }

    @Override
    public void start() throws Exception {
        log.debug("Starting component " + this.getComponentName());
    }

    @Override
    public void stop() throws Exception {
        log.debug("Stopping component " + this.getComponentName());
    }

    @Override
    public void shutdown() throws Exception {
        log.debug("Shutdown for component " + this.getComponentName());
        this.componentKillFlag = true;
    }

    public final String getComponentName() {
        return this.factoryComponentName;
    }

    final void setComponentName(String s) {
        this.factoryComponentName = s;
    }

    public final String getComponentScope() {
        return this.factoryComponentScope;
    }

    final void setComponentScope(String s) {
        this.factoryComponentScope = s;
    }

    public final String getComponentDescription() {
        return this.factoryComponentDescription;
    }

    final void setComponentDescription(String s) {
        this.factoryComponentDescription = s;
    }

    public Object factoryLookup(String path) {
        return Factory.lookup(path, this.getComponentName());
    }

    public void setComponentAlias(String alias) {
        this.factoryComponentAlias = alias;
    }

    public String getComponentAlias() {
        return this.factoryComponentAlias;
    }

    protected void addPeriodicTask(String methodName, long sleepInterval) {
        try {
            Method m = this.getClass().getDeclaredMethod(methodName, new Class[0]);
            this.addPeriodicTask(m, sleepInterval);
        }
        catch (NoSuchMethodException e) {
            log.error("Error: ", (Throwable)e);
        }
    }

    protected void addPeriodicTask(final Method m, final long sleepInterval) {
        if (this.getComponentScope().equals("global")) {
            Runnable periodicRunnable = new Runnable(){

                @Override
                public void run() {
                    block4: while (true) {
                        try {
                            m.invoke((Object)BasicFactoryElement.this, new Object[0]);
                            if (BasicFactoryElement.this.componentKillFlag) {
                                return;
                            }
                        }
                        catch (Throwable e) {
                            log.error("Error invoking periodic task: ", e);
                        }
                        try {
                            long totalSlept = 0L;
                            do {
                                if (totalSlept >= sleepInterval) continue block4;
                                Thread.sleep(1000L);
                                totalSlept += 1000L;
                            } while (!BasicFactoryElement.this.componentKillFlag);
                            return;
                        }
                        catch (InterruptedException e) {
                            log.error("Error: ", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            };
            Thread thr = new Thread(periodicRunnable, this.getComponentName() + " thread");
            thr.setPriority(1);
            thr.setDaemon(true);
            thr.start();
        } else {
            log.error("Cannot add periodic task for component " + this.getComponentName() + ". Scope is " + this.getComponentScope());
        }
    }
}

