/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard;

import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.dashboard.LocaleManager;
import org.jboss.dashboard.annotation.DestroyableProcessor;
import org.jboss.dashboard.annotation.StartableProcessor;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.commons.io.DirectoriesScanner;
import org.jboss.dashboard.factory.Factory;
import org.jboss.dashboard.factory.FactoryWork;

@ApplicationScoped
public class Application {
    @Inject
    protected StartableProcessor startupProcessor;
    @Inject
    protected DestroyableProcessor destroyableProcessor;
    protected boolean upAndRunning = false;
    protected String libDirectory = null;
    protected String baseCfgDirectory = null;
    protected String baseAppDirectory = null;
    protected transient Set<File> jarFiles = null;
    protected transient Factory globalFactory = null;

    public static Application lookup() {
        return (Application)CDIBeanLocator.getBeanByType(Application.class);
    }

    public String getBaseAppDirectory() {
        return this.baseAppDirectory;
    }

    public String getBaseCfgDirectory() {
        return this.baseCfgDirectory;
    }

    public void setBaseAppDirectory(String newBaseAppDirectory) {
        this.baseAppDirectory = newBaseAppDirectory;
    }

    public void setBaseCfgDirectory(String newBaseCfgDirectory) {
        this.baseCfgDirectory = newBaseCfgDirectory;
    }

    public String getLibDirectory() {
        return this.libDirectory;
    }

    public void setLibDirectory(String libDirectory) {
        this.libDirectory = libDirectory;
    }

    public Factory getGlobalFactory() {
        return this.globalFactory;
    }

    public void setGlobalFactory(Factory globalFactory) {
        if (this.globalFactory != null) {
            Factory.doWork(new FactoryWork(){

                @Override
                public void doWork() {
                    Application.this.globalFactory.destroy();
                }
            });
        }
        this.globalFactory = globalFactory;
    }

    public boolean isUpAndRunning() {
        return this.upAndRunning;
    }

    public void setUpAndRunning(boolean upAndRunning) {
        this.upAndRunning = upAndRunning;
    }

    public void start() throws Exception {
        this.startupProcessor.wakeUpStartableBeans();
        this.setUpAndRunning(true);
    }

    public void shutdown() {
        this.destroyableProcessor.destroyBeans();
        this.setUpAndRunning(false);
        this.setGlobalFactory(null);
    }

    public Set<File> getJarFiles() {
        if (this.jarFiles != null) {
            return this.jarFiles;
        }
        this.jarFiles = new HashSet<File>();
        File libDir = new File(this.libDirectory);
        File[] jars = new DirectoriesScanner("jar").findFiles(libDir);
        for (int i = 0; i < jars.length; ++i) {
            File jar = jars[i];
            String jarName = jar.getName();
            if (!jarName.startsWith("dashboard-")) continue;
            this.jarFiles.add(jar);
        }
        return this.jarFiles;
    }

    public String getCopyright() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        String currentYear = Integer.toString(cal.get(1));
        ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.messages", LocaleManager.currentLocale());
        return MessageFormat.format(i18n.getString("config.copyright"), currentYear);
    }
}

