/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.cluster;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jboss.dashboard.annotation.Destroyable;
import org.jboss.dashboard.annotation.Priority;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.cluster.ClusterNode;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ClusterNodesManager
implements Startable,
Destroyable {
    public static transient Logger log = LoggerFactory.getLogger((String)ClusterNodesManager.class.getName());
    private Long currentNodeId;

    @Override
    public Priority getPriority() {
        return Priority.HIGH;
    }

    @Override
    public void start() throws Exception {
        final String ip = this.getIPAddress();
        log.info("Registering cluster node with ip address " + ip);
        final ClusterNode[] result = new ClusterNode[1];
        new HibernateTxFragment(true){

            @Override
            protected void txFragment(Session session) throws Exception {
                ClusterNode node = new ClusterNode();
                node.setNodeAddress(ip);
                node.setStartupTime(new Date());
                node.setNodeStatus(ClusterNode.ClusterNodeStatus.RUNNING.name());
                session.saveOrUpdate((Object)node);
                session.flush();
                result[0] = node;
            }
        }.execute();
        if (result[0] != null) {
            this.currentNodeId = result[0].getId();
        }
        log.info("Successfuly resgister cluster node with ip address " + ip + " and identifier " + this.currentNodeId);
    }

    @Override
    public void destroy() throws Exception {
        final Long nodeId = this.currentNodeId;
        log.info("Deregistering cluster node with id " + nodeId);
        new HibernateTxFragment(true){

            @Override
            protected void txFragment(Session session) throws Exception {
                Query query = session.createQuery("delete from " + ClusterNode.class.getName() + " cn  where cn.id = :idNode");
                query.setLong("idNode", nodeId.longValue());
                query.executeUpdate();
                session.flush();
            }
        }.execute();
        this.currentNodeId = null;
        log.info("Successfully deregistered cluster node with id " + nodeId);
    }

    public List<ClusterNode> getNodeByStatus(final ClusterNode.ClusterNodeStatus status) throws Exception {
        final ArrayList<ClusterNode> result = new ArrayList<ClusterNode>();
        if (status != null) {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Query query = session.createQuery("from " + ClusterNode.class.getName() + " cn  where cn.nodeStatus = :nStatus");
                    query.setString("nStatus", status.name());
                    List queryResult = query.list();
                    if (queryResult != null && !queryResult.isEmpty()) {
                        for (Object obj : queryResult) {
                            result.add((ClusterNode)obj);
                        }
                    }
                }
            }.execute();
        }
        return result;
    }

    public ClusterNode getNodeById(final Long id) throws Exception {
        final ClusterNode[] result = new ClusterNode[1];
        if (id != null) {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Query query = session.createQuery("from " + ClusterNode.class.getName() + "  cn  where cn.id = :idToSearch");
                    query.setLong("idToSearch", id.longValue());
                    List queryResult = query.list();
                    if (queryResult.size() > 1) {
                        log.error("There is more than one cluster node resgistered for identifier " + id + ".!!!");
                    }
                    if (!queryResult.isEmpty()) {
                        result[0] = (ClusterNode)queryResult.get(0);
                    }
                }
            }.execute();
        }
        return result[0];
    }

    protected String getIPAddress() throws SocketException {
        String ip = null;
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            if (iface.isLoopback() || !iface.isUp()) continue;
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                ip = addr.getHostAddress();
            }
        }
        return ip;
    }

    public void setNodeStatus(final Long nodeId, final ClusterNode.ClusterNodeStatus newStatus) throws Exception {
        new HibernateTxFragment(){

            @Override
            protected void txFragment(Session session) throws Exception {
                ClusterNode node = ClusterNodesManager.this.getNodeById(nodeId);
                if (node == null) {
                    log.error("Cannot set status " + newStatus.name() + " to target node. Node with identifier " + nodeId + " not found.");
                } else {
                    node.setNodeStatus(newStatus.name());
                    session.saveOrUpdate((Object)node);
                    session.flush();
                }
            }
        }.execute();
    }

    public void setCurrentNodeStatus(ClusterNode.ClusterNodeStatus newStatus) throws Exception {
        this.setNodeStatus(this.currentNodeId, newStatus);
    }
}

