/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.jboss.dashboard.annotation.Priority;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.cluster.ClusterNode;
import org.jboss.dashboard.cluster.ClusterNodesManager;
import org.jboss.dashboard.database.InstalledModule;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.jboss.dashboard.factory.InitialModule;
import org.jboss.dashboard.factory.InitialModuleRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class InitialModulesManager
implements Startable {
    public static transient Logger log = LoggerFactory.getLogger((String)InitialModulesManager.class.getName());
    @Inject
    private InitialModuleRegistry initialModuleRegistry;
    @Inject
    private ClusterNodesManager clusterNodesManager;
    @Inject
    @Config(value="true")
    private boolean initialModulesEnabled;

    @Override
    public Priority getPriority() {
        return Priority.LOW;
    }

    @Override
    public void start() throws Exception {
        if (this.initialModulesEnabled) {
            boolean doTheInstall = this.shouldInstallModules();
            if (!doTheInstall) {
                log.info("Skipping initial modules installation as other node is currenly installing.");
                return;
            }
            List<InitialModule> modules = this.initialModuleRegistry.getInitialModulesRegistered();
            for (final InitialModule module : modules) {
                new HibernateTxFragment(true){

                    @Override
                    protected void txFragment(Session session) throws Exception {
                        InstalledModule currentVersion = (InstalledModule)session.get(InstalledModule.class, (Serializable)((Object)module.getName()), LockOptions.UPGRADE);
                        if (currentVersion == null) {
                            if (module.doTheInstall()) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Installed module " + module.getName() + " version " + module.getVersion());
                                }
                                currentVersion = new InstalledModule(module.getName(), 1L);
                                session.save((Object)currentVersion);
                                session.flush();
                            } else {
                                log.warn("Error installing module " + module.getName() + " version " + module.getVersion());
                            }
                        } else if (currentVersion.getVersion() < module.getVersion()) {
                            if (module.doTheUpgrade(currentVersion.getVersion())) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Upgraded module " + module.getName() + " to version " + module.getVersion());
                                }
                                currentVersion.setVersion(module.getVersion());
                                session.saveOrUpdate((Object)currentVersion);
                                session.flush();
                            } else {
                                log.warn("Error upgrading module " + module.getName() + " to version " + module.getVersion());
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Module " + module.getName() + " version " + module.getVersion() + "is already installed.");
                        }
                    }
                }.execute();
            }
            this.finishInstallation();
        } else {
            log.info("Initial modules are NOT being installed.");
        }
    }

    public boolean isInitialModulesEnabled() {
        return this.initialModulesEnabled;
    }

    public void setInitialModulesEnabled(boolean initialModulesEnabled) {
        this.initialModulesEnabled = initialModulesEnabled;
    }

    protected boolean shouldInstallModules() throws Exception {
        final Boolean[] result = new Boolean[]{true};
        new HibernateTxFragment(true, true){

            @Override
            protected void txFragment(Session session) throws Exception {
                List<ClusterNode> installingModulesNodes = InitialModulesManager.this.clusterNodesManager.getNodeByStatus(ClusterNode.ClusterNodeStatus.INSTALLING_MODULES);
                if (installingModulesNodes != null && !installingModulesNodes.isEmpty()) {
                    result[0] = false;
                } else {
                    result[0] = true;
                    InitialModulesManager.this.clusterNodesManager.setCurrentNodeStatus(ClusterNode.ClusterNodeStatus.INSTALLING_MODULES);
                }
            }
        }.execute();
        return result[0];
    }

    protected void finishInstallation() throws Exception {
        new HibernateTxFragment(true){

            @Override
            protected void txFragment(Session session) throws Exception {
                InitialModulesManager.this.clusterNodesManager.setCurrentNodeStatus(ClusterNode.ClusterNodeStatus.RUNNING);
            }
        }.execute();
    }
}

