/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler.memory;

import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.database.hibernate.HibernateInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MemoryProfiler {
    private static transient Logger log = LoggerFactory.getLogger((String)MemoryProfiler.class.getName());
    @Inject
    @Config(value="1000000")
    private long minMemorySize;
    @Inject
    @Config(value="0.05")
    private float minMemoryPercentage;
    public static final String[] SIZE_UNITS = new String[]{"bytes", "Kb", "Mb", "Gb", "Tb", "Pb"};

    public static MemoryProfiler lookup() {
        return (MemoryProfiler)CDIBeanLocator.getBeanByType(MemoryProfiler.class);
    }

    public long getMinMemorySize() {
        return this.minMemorySize;
    }

    public void setMinMemorySize(long minMemorySize) {
        this.minMemorySize = minMemorySize;
    }

    public float getMinMemoryPercentage() {
        return this.minMemoryPercentage;
    }

    public void setMinMemoryPercentage(float minMemoryPercentage) {
        this.minMemoryPercentage = minMemoryPercentage;
    }

    public boolean isLowMemory() {
        long freeMemory = this.getFreeMemoryInBytes();
        long totalMemory = this.getTotalMemoryInBytes();
        if (freeMemory < this.minMemorySize) {
            return true;
        }
        float percentage = (float)((double)freeMemory / ((double)totalMemory * 1.0));
        return percentage < this.minMemoryPercentage;
    }

    public long getFreeMemoryInBytes() {
        return Runtime.getRuntime().freeMemory();
    }

    public long getTotalMemoryInBytes() {
        return Runtime.getRuntime().totalMemory();
    }

    public MemoryProfiler freeMemory() {
        long freeMemory = this.getFreeMemoryInBytes();
        this.collectGarbage();
        if (this.isLowMemory()) {
            this.freeEvenMoreMemory();
            log.warn("Hibernate caches had to be deleted to free memory. Consider decreasing cache sizes, or increasing memory for current application.");
        }
        long newFree = this.getFreeMemoryInBytes();
        long newTotal = this.getTotalMemoryInBytes();
        float percentage = (float)((double)newFree * 100.0 / ((double)newTotal * 1.0));
        long freed = newFree - freeMemory;
        log.info("Freed " + MemoryProfiler.formatSize(freed) + " bytes. Total = " + MemoryProfiler.formatSize(newTotal) + ". Free = " + MemoryProfiler.formatSize(newFree) + " (" + percentage + "%)");
        return this;
    }

    protected void freeEvenMoreMemory() {
        HibernateInitializer hibernateInitializer = CoreServices.lookup().getHibernateInitializer();
        hibernateInitializer.evictAllCaches();
        this.collectGarbage();
    }

    public long getMemoryUsedInBytes() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    private void collectGarbage() {
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(10L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(10L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static String formatSize(long bytes) {
        for (int exp = SIZE_UNITS.length - 1; exp >= 0; --exp) {
            String sizeUnit = SIZE_UNITS[exp];
            double size = (double)bytes / Math.pow(1024.0, exp);
            if ((long)size <= 0L) continue;
            NumberFormat df = DecimalFormat.getInstance();
            return df.format(size) + " " + sizeUnit;
        }
        return bytes + " bytes";
    }
}

