/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.misc;

import java.util.HashMap;
import java.util.Map;

public final class Chronometer {
    protected Map marks = new HashMap();
    protected Long stopTime;

    public void start() {
        this.stopTime = null;
        this.marks.clear();
        this.marks.put("START", new Long(System.currentTimeMillis()));
    }

    public void stop() {
        this.stopTime = new Long(System.currentTimeMillis());
    }

    public void resume() {
        this.stopTime = null;
    }

    public void start(String mark) {
        this.marks.put(mark, new Long(System.currentTimeMillis()));
    }

    public long elapsedTime() {
        return this.elapsedTime("START");
    }

    public long elapsedTime(String mark) {
        if (!this.marks.containsKey(mark)) {
            return 0L;
        }
        Long mtime = (Long)this.marks.get(mark);
        long stop = this.stopTime != null ? this.stopTime : System.currentTimeMillis();
        return stop - mtime;
    }

    public static String formatElapsedTime(long millis) {
        long milliseconds = millis;
        long seconds = milliseconds / 1000L;
        milliseconds %= 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        long weeks = days / 7L;
        days %= 7L;
        double secondsd = (double)(seconds * 1000L + milliseconds) / 1000.0;
        StringBuffer buf = new StringBuffer();
        if (weeks > 0L) {
            buf.append(weeks).append(" weeks ");
        }
        if (days > 0L) {
            buf.append(days).append("d ");
        }
        if (hours > 0L) {
            buf.append(hours).append("h ");
        }
        if (minutes > 0L) {
            buf.append(minutes).append("m ");
        }
        if (secondsd > 0.0) {
            buf.append(secondsd).append("s");
        }
        if (buf.length() == 0) {
            return "0s";
        }
        return buf.toString();
    }

    public static void main(String[] arg) throws Exception {
        Chronometer chrono = new Chronometer();
        chrono.start();
        Thread.sleep(3000L);
        chrono.start("INTERMEDIATE");
        Thread.sleep(2000L);
        System.out.println("INTERMEDIATE " + chrono.elapsedTime("INTERMEDIATE"));
        System.out.println("TOTAL " + chrono.elapsedTime());
        Thread.sleep(1000L);
        System.out.println("INTERMEDIATE " + chrono.elapsedTime("INTERMEDIATE"));
        System.out.println("TOTAL " + chrono.elapsedTime());
    }
}

