/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.factory.Component;
import org.jboss.dashboard.factory.DescriptorFile;
import org.jboss.dashboard.factory.FactoryLifecycle;
import org.jboss.dashboard.factory.LookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentsTree {
    private static transient Logger log = LoggerFactory.getLogger((String)ComponentsTree.class.getName());
    private List configurationFiles;
    private Map mappings;
    private Map treeMappings;
    private Map aliases;
    private Map reverseAliases;
    private long componentOrderCounter = 0L;

    public synchronized long getNewOrderCounter() {
        return this.componentOrderCounter++;
    }

    public ComponentsTree(List files) {
        this.configurationFiles = files;
        this.mappings = new TreeMap();
        this.aliases = new TreeMap();
        this.reverseAliases = new TreeMap();
        this.treeMappings = new TreeMap();
        this.init();
    }

    protected void init() {
        for (int i = 0; i < this.configurationFiles.size(); ++i) {
            DescriptorFile file = (DescriptorFile)this.configurationFiles.get(i);
            log.debug("Loading properties file " + file.getSource());
            Properties prop = file.getMappedProperties();
            Component component = (Component)this.mappings.get(file.getComponentName());
            if (component == null) {
                component = this.makeComponentInstance(file.getComponentName());
            }
            component.addProperties(prop, file.getSource());
            this.addToMappings(file.getComponentName(), component);
        }
        Iterator it = this.mappings.keySet().iterator();
        while (it.hasNext()) {
            Component component = (Component)this.mappings.get(it.next());
            component.validate();
        }
    }

    protected void addToMappings(String name, Component component) {
        this.mappings.put(name, component);
        if (!StringUtils.isEmpty((String)component.getAlias())) {
            String previousValue = (String)this.aliases.get(component.getAlias());
            if (previousValue != null && !previousValue.equals(name)) {
                log.error("Cannot use alias " + component.getAlias() + " for component " + name + ". There is another component for this alias: " + previousValue);
            } else {
                this.aliases.put(component.getAlias(), name);
                this.reverseAliases.put(name, component.getAlias());
            }
        }
        Map currentLevel = this.treeMappings;
        StringTokenizer stk = new StringTokenizer(name, ".");
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (stk.hasMoreTokens()) {
                HashMap level = (HashMap)currentLevel.get(token);
                if (level == null) {
                    level = new HashMap();
                    currentLevel.put(token, level);
                }
                currentLevel = level;
                continue;
            }
            currentLevel.put(token, component);
        }
    }

    public Component getComponent(String path) {
        return this.getComponent(path, null);
    }

    public Component getComponent(String path, String relativePath) {
        String alias;
        if (relativePath != null && path.startsWith(".")) {
            path = this.calculateRelativePath(path, relativePath);
        }
        if ((alias = (String)this.aliases.get(path)) != null) {
            path = alias;
        }
        return (Component)this.mappings.get(path);
    }

    protected String calculateRelativePath(String parameter, String currentPath) {
        int lastDotPosition;
        int initialDotsNum;
        for (initialDotsNum = 0; initialDotsNum < parameter.length() && parameter.charAt(initialDotsNum) == '.'; ++initialDotsNum) {
        }
        int initialDotsNumCopy = initialDotsNum;
        for (lastDotPosition = currentPath.length() - 1; lastDotPosition > 0 && initialDotsNumCopy > 0; --lastDotPosition) {
            if (currentPath.charAt(lastDotPosition) != '.') continue;
            --initialDotsNumCopy;
        }
        if (lastDotPosition <= 0) {
            log.error("Cannot calculate path of " + parameter + " relative to " + currentPath);
            return parameter;
        }
        return currentPath.substring(0, lastDotPosition + 1) + parameter.substring(initialDotsNum - 1);
    }

    public Object lookup(String s) throws LookupException {
        return this.lookup(s, null);
    }

    public Object lookup(String s, String relativeToPath) throws LookupException {
        if (log.isDebugEnabled()) {
            log.debug("Looking up path " + s);
        }
        Component component = this.getComponent(s, relativeToPath);
        Object obj = null;
        if (component != null) {
            obj = component.getObject();
        }
        return obj;
    }

    protected Component makeComponentInstance(String name) {
        return new Component(name, this);
    }

    public String toString() {
        return this.mappings.toString();
    }

    public Map getTreeMappings() {
        return this.treeMappings;
    }

    public String getAlias(String path, String relativePath) {
        if (relativePath != null && path.startsWith(".")) {
            path = this.calculateRelativePath(path, relativePath);
        }
        return (String)this.reverseAliases.get(path);
    }

    public void destroy() {
        TreeSet<Component> sortedSet = new TreeSet<Component>(new Comparator(){

            public int compare(Object o1, Object o2) {
                Component c1 = (Component)o1;
                Component c2 = (Component)o2;
                return -new Long(c1.getCreationOrderNumber()).compareTo(new Long(c2.getCreationOrderNumber()));
            }
        });
        for (String key : this.mappings.keySet()) {
            Component comp = (Component)this.mappings.get(key);
            if (!"global".equals(comp.getScope())) continue;
            Object object = null;
            try {
                object = comp.getTheInstance();
            }
            catch (LookupException e) {
                log.error("Error: ", (Throwable)e);
            }
            if (object == null || !(object instanceof FactoryLifecycle)) continue;
            sortedSet.add(comp);
        }
        for (Component component : sortedSet) {
            Object object = null;
            try {
                object = component.getTheInstance();
            }
            catch (LookupException e) {
                log.error("Error: ", (Throwable)e);
            }
            if (object == null || !(object instanceof FactoryLifecycle)) continue;
            FactoryLifecycle ob = (FactoryLifecycle)object;
            try {
                ob.shutdown();
            }
            catch (Exception e) {
                log.error("Error shutting down " + component.getName() + ": ", (Throwable)e);
            }
        }
    }
}

