/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.factory;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.commons.io.DirectoriesScanner;
import org.jboss.dashboard.factory.ComponentsContextManager;
import org.jboss.dashboard.factory.ComponentsTree;
import org.jboss.dashboard.factory.DescriptorFile;
import org.jboss.dashboard.factory.FactoryWork;
import org.jboss.dashboard.factory.LookupException;
import org.jboss.dashboard.profiler.Profiler;
import org.jboss.dashboard.profiler.ThreadProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Factory {
    private static transient Logger log = LoggerFactory.getLogger((String)Factory.class.getName());
    public static final String FACTORY_FILENAME = "factory.cfg";
    public static final String FACTORY_EXTENSION = "factory";
    public static final String FACTORY_COMMENT_CHAR = "#";
    protected ComponentsTree tree = null;
    protected List<String> modules = null;

    public static Factory getFactory(File configDir) {
        Factory factory;
        try {
            factory = new Factory(configDir);
        }
        catch (IOException e) {
            log.error("Error creating the factory. An empty factory will be created. ", (Throwable)e);
            return new Factory();
        }
        return factory;
    }

    public static Factory getFactory(ZipInputStream zis) {
        Factory factory;
        try {
            factory = new Factory(zis);
        }
        catch (IOException e) {
            log.error("Error creating the factory. An empty factory will be created. ", (Throwable)e);
            return new Factory();
        }
        return factory;
    }

    protected Factory(File configDir) throws IOException {
        if (configDir.isDirectory()) {
            this.init(configDir);
        } else {
            this.init(new ZipInputStream(new BufferedInputStream(new FileInputStream(configDir))));
        }
    }

    protected Factory(ZipInputStream zis) throws IOException {
        this.init(zis);
    }

    protected Factory() {
    }

    protected synchronized void init(ZipInputStream zis) throws IOException {
        ZipEntry entry;
        ArrayList<String> entriesOrder = new ArrayList<String>();
        HashMap<String, HashMap<String, Properties>> entries = new HashMap<String, HashMap<String, Properties>>();
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            String entryName = entry.getName().replace('\\', '/');
            if (entryName.equals(FACTORY_FILENAME)) {
                String line;
                log.debug("Using config file: zip:/" + entryName);
                BufferedReader input = new BufferedReader(new InputStreamReader(zis));
                while ((line = input.readLine()) != null) {
                    if (!this.checkModuleName(line)) continue;
                    entriesOrder.add(line);
                }
                continue;
            }
            if (entryName.indexOf(47) == -1) {
                log.warn("Ignoring entry inside ZIP " + entryName);
                continue;
            }
            int index = entryName.indexOf(47);
            Properties prop = new Properties();
            try {
                prop.load(zis);
            }
            catch (IOException e) {
                log.error("Error processing entry zip:/" + entryName + ". It will be ignored.", (Throwable)e);
                continue;
            }
            String product = entryName.substring(0, index);
            String component = entryName.substring(index + 1, entryName.length() - 1 - FACTORY_EXTENSION.length()).replace('/', '.').replace('\\', '.');
            HashMap<String, Properties> m = (HashMap<String, Properties>)entries.get(product);
            if (m == null) {
                m = new HashMap<String, Properties>();
                entries.put(product, m);
            }
            m.put(component, prop);
        }
        zis.close();
        ArrayList<DescriptorFile> descriptorFiles = new ArrayList<DescriptorFile>();
        for (int i = 0; i < entriesOrder.size(); ++i) {
            String product = (String)entriesOrder.get(i);
            Map components = (Map)entries.get(product);
            if (components == null || components.isEmpty()) continue;
            for (String componentName : components.keySet()) {
                Properties componentProperties = (Properties)components.get(componentName);
                descriptorFiles.add(new DescriptorFile(componentName, componentProperties, "zip:/" + product + "/" + componentName.replace('.', '/') + "." + FACTORY_EXTENSION));
            }
        }
        this.addDescriptorFiles(descriptorFiles);
    }

    protected synchronized void init(File factoryDir) throws IOException {
        String moduleName;
        log.info("Configuring Factory from directory: " + factoryDir);
        File configFile = new File(factoryDir.getAbsolutePath() + "/" + FACTORY_FILENAME);
        log.debug("Using config file: " + configFile);
        BufferedReader input = new BufferedReader(new FileReader(configFile));
        ArrayList<DescriptorFile> descriptorFiles = new ArrayList<DescriptorFile>();
        this.modules = new ArrayList<String>();
        while ((moduleName = input.readLine()) != null) {
            File moduleZip;
            if (!this.checkModuleName(moduleName)) continue;
            this.modules.add(moduleName);
            List<DescriptorFile> moduleFiles = this.initModuleFromJar(moduleName);
            descriptorFiles.addAll(moduleFiles);
            File moduleDir = new File(factoryDir.getAbsolutePath() + "/" + moduleName);
            if (moduleDir.exists() && moduleDir.isDirectory()) {
                log.debug("Adding " + moduleDir + " to the list of tree roots.");
                moduleFiles = this.initModuleFromDir(moduleDir);
                descriptorFiles.addAll(moduleFiles);
            }
            if (!(moduleZip = new File(factoryDir.getAbsolutePath() + "/" + moduleName + ".zip")).exists() || !moduleZip.isFile()) continue;
            log.debug("Adding " + moduleZip + " to the list of tree roots.");
            moduleFiles = this.initModuleFromZip(moduleZip);
            descriptorFiles.addAll(moduleFiles);
        }
        input.close();
        this.addDescriptorFiles(descriptorFiles);
    }

    protected List<DescriptorFile> initModuleFromDir(File moduleDir) throws IOException {
        ArrayList<DescriptorFile> descriptorFiles = new ArrayList<DescriptorFile>();
        DirectoriesScanner scanner = new DirectoriesScanner(FACTORY_EXTENSION);
        File[] descriptorsInside = scanner.findFiles(moduleDir);
        int preffixLength = moduleDir.getCanonicalPath().length() + 1;
        for (int i = 0; i < descriptorsInside.length; ++i) {
            File file = descriptorsInside[i];
            String componentName = file.getCanonicalPath();
            componentName = componentName.substring(preffixLength, componentName.length() - 1 - FACTORY_EXTENSION.length());
            componentName = componentName.replace('/', '.');
            componentName = componentName.replace('\\', '.');
            Properties prop = new Properties();
            try {
                FileInputStream fis = new FileInputStream(file);
                prop.load(fis);
                fis.close();
                descriptorFiles.add(new DescriptorFile(componentName, prop, file.getCanonicalPath()));
                continue;
            }
            catch (IOException e) {
                log.error("Error processing file " + file + ". It will be ignored.", (Throwable)e);
            }
        }
        return descriptorFiles;
    }

    protected List<DescriptorFile> initModuleFromZip(File moduleZip) throws IOException {
        ArrayList<DescriptorFile> descriptorFiles = new ArrayList<DescriptorFile>();
        ZipFile zf = new ZipFile(moduleZip);
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (!entry.getName().endsWith(FACTORY_EXTENSION) || entry.isDirectory()) continue;
            InputStream is = zf.getInputStream(entry);
            String componentName = entry.getName();
            componentName = componentName.substring(0, componentName.length() - 1 - FACTORY_EXTENSION.length());
            componentName = componentName.replace('/', '.');
            componentName = componentName.replace('\\', '.');
            Properties prop = new Properties();
            try {
                prop.load(is);
                is.close();
                descriptorFiles.add(new DescriptorFile(componentName, prop, moduleZip + "!" + entry.getName()));
            }
            catch (IOException e) {
                log.error("Error processing file " + entry.getName() + " inside " + moduleZip + ". It will be ignored.", (Throwable)e);
            }
        }
        return descriptorFiles;
    }

    protected List<DescriptorFile> initModuleFromJar(String moduleName) throws IOException {
        ArrayList<DescriptorFile> descriptorFiles = new ArrayList<DescriptorFile>();
        String libPath = Application.lookup().getBaseAppDirectory() + File.separator + "WEB-INF" + File.separator + "lib";
        File libDir = new File(libPath);
        DirectoriesScanner ds = new DirectoriesScanner("jar");
        File[] jars = ds.findFiles(libDir);
        for (int i = 0; i < jars.length; ++i) {
            File jar = jars[i];
            if (!jar.getName().startsWith(moduleName)) continue;
            List<DescriptorFile> jarDescriptors = this.initModuleFromZip(jar);
            descriptorFiles.addAll(jarDescriptors);
        }
        return descriptorFiles;
    }

    protected void addDescriptorFiles(List descriptorFiles) {
        this.tree = new ComponentsTree(descriptorFiles);
        log.info("Factory configured.");
        if (log.isDebugEnabled()) {
            log.debug("Using factory components " + this.tree);
        }
    }

    public void destroy() {
        this.getTree().destroy();
    }

    public List<String> getModules() {
        return this.modules;
    }

    public ComponentsTree getTree() {
        return this.tree;
    }

    protected Object doLookup(String path, String relativeToPath) {
        if (this.tree == null) {
            return null;
        }
        try {
            return this.tree.lookup(path, relativeToPath);
        }
        catch (LookupException e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }

    protected String doGetAlias(String path, String relativeToPath) {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getAlias(path, relativeToPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWork(FactoryWork work, boolean profile) {
        ThreadProfile threadProfile;
        boolean profileOwner;
        boolean contextOwner;
        boolean bl = contextOwner = !ComponentsContextManager.isContextStarted();
        if (contextOwner) {
            ComponentsContextManager.startContext();
        }
        boolean bl2 = profileOwner = (threadProfile = Profiler.lookup().getCurrentThreadProfile()) == null;
        if (profile && profileOwner) {
            threadProfile = Profiler.lookup().beginThreadProfile();
        }
        try {
            work.doWork();
        }
        finally {
            if (profile && profileOwner) {
                Profiler.lookup().finishThreadProfile(threadProfile);
            }
            if (contextOwner) {
                ComponentsContextManager.clearContext();
            }
        }
    }

    public static Object lookup(String path) {
        Factory factory = Application.lookup().getGlobalFactory();
        if (factory == null) {
            return null;
        }
        return factory.doLookup(path, null);
    }

    public static Object lookup(String path, String relativeToPath) {
        return Application.lookup().getGlobalFactory().doLookup(path, relativeToPath);
    }

    public static String getAlias(String path) {
        return Application.lookup().getGlobalFactory().doGetAlias(path, null);
    }

    public static Object getAlias(String path, String relativeToPath) {
        return Application.lookup().getGlobalFactory().doGetAlias(path, relativeToPath);
    }

    public static void doWork(FactoryWork work) {
        Application.lookup().getGlobalFactory().runWork(work, true);
    }

    public static void doWork(FactoryWork work, boolean profileWork) {
        Application.lookup().getGlobalFactory().runWork(work, profileWork);
    }

    protected boolean checkModuleName(String moduleName) {
        return !StringUtils.isEmpty((String)moduleName) && !moduleName.startsWith(FACTORY_COMMENT_CHAR);
    }
}

