/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="localeManager")
public class LocaleManager {
    private static transient Logger log = LoggerFactory.getLogger((String)LocaleManager.class.getName());
    @Inject
    @Config(value="en,es,de,fr,pt,ja,zh")
    protected String[] installedLocaleIds;
    @Inject
    @Config(value="en")
    protected String defaultLocaleId;
    private transient Locale[] availableLocales;
    private transient Locale currentLocale;
    private transient Locale currentEditLocale;
    private transient Locale defaultLocale;
    private ResourceBundle.Control fallbackControl;

    public static LocaleManager lookup() {
        return (LocaleManager)CDIBeanLocator.getBeanByName("localeManager");
    }

    @PostConstruct
    public void init() {
        this.fallbackControl = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
        ArrayList<Locale> availableLocalesList = new ArrayList<Locale>();
        for (String locId : this.installedLocaleIds) {
            Locale locale = this.getLocaleById(locId);
            if (locale == null) continue;
            availableLocalesList.add(locale);
        }
        this.availableLocales = availableLocalesList.toArray(new Locale[availableLocalesList.size()]);
        this.defaultLocale = this.getLocaleById(this.defaultLocaleId);
    }

    public String[] getInstalledLocaleIds() {
        return this.installedLocaleIds;
    }

    public void setInstalledLocaleIds(String[] installedLocaleIds) {
        this.installedLocaleIds = installedLocaleIds;
    }

    public String getDefaultLocaleId() {
        return this.defaultLocaleId;
    }

    public void setDefaultLocaleId(String defaultLocale) {
        Locale l = this.getLocaleById(defaultLocale);
        if (l != null) {
            this.setDefaultLocale(l);
        }
    }

    public void setDefaultLocale(Locale defaultLocale) {
        Locale l = this.getPlatformLocale(defaultLocale);
        if (l != null) {
            this.defaultLocaleId = l.toString();
            this.defaultLocale = l;
        }
    }

    public Locale getLocaleById(String localeId) {
        for (Locale locale : this.getAllLocales()) {
            if (!locale.toString().equals(localeId)) continue;
            return locale;
        }
        return null;
    }

    public Locale[] getAllLocales() {
        return Locale.getAvailableLocales();
    }

    public Locale[] getPlatformAvailableLocales() {
        return this.availableLocales;
    }

    public Locale getCurrentEditLocale() {
        return this.currentEditLocale == null ? this.defaultLocale : this.currentEditLocale;
    }

    public void setCurrentEditLocale(Locale l) {
        this.currentEditLocale = this.defaultLocale;
        Locale platformLocale = this.getPlatformLocale(l);
        if (platformLocale != null) {
            this.currentEditLocale = platformLocale;
        }
    }

    public Locale getCurrentLocale() {
        return this.currentLocale == null ? this.defaultLocale : this.currentLocale;
    }

    public void setCurrentLocale(Locale l) {
        this.currentLocale = this.defaultLocale;
        Locale platformLocale = this.getPlatformLocale(l);
        if (platformLocale != null) {
            this.currentLocale = platformLocale;
        }
    }

    public Locale getPlatformLocale(Locale l) {
        for (Locale locale : this.availableLocales) {
            String lang = locale.getLanguage();
            if (!lang.equals(l.getLanguage())) continue;
            return locale;
        }
        return null;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    protected String[] localeToString(Locale[] locales) {
        ArrayList<String> langs = new ArrayList<String>();
        for (Locale locale : locales) {
            String s = locale.toString();
            langs.add(s);
        }
        return langs.toArray(new String[langs.size()]);
    }

    public String[] getAllLanguages() {
        return this.localeToString(this.getAllLocales());
    }

    public String[] getPlatformAvailableLangs() {
        return this.localeToString(this.getPlatformAvailableLocales());
    }

    public String[] getLangs() {
        return this.getPlatformAvailableLangs();
    }

    public String getCurrentEditLang() {
        return this.getCurrentEditLocale().toString();
    }

    public void setCurrentEditLang(String langId) {
        Locale locale = this.getLocaleById(langId);
        if (locale != null) {
            this.setCurrentEditLocale(locale);
        } else {
            log.error("Can't set edit lang to " + langId);
        }
    }

    public String getCurrentLang() {
        return this.getCurrentLocale().toString();
    }

    public void setCurrentLang(String langId) {
        Locale locale = this.getLocaleById(langId);
        if (locale != null) {
            this.setCurrentLocale(locale);
        } else {
            log.error("Can't set current lang to " + langId);
        }
    }

    public String getDefaultLang() {
        return this.getDefaultLocale().toString();
    }

    public Object localize(Map localizedData) {
        if (localizedData == null || localizedData.isEmpty()) {
            return null;
        }
        Object data = localizedData.get(this.getCurrentLang());
        if (!(data == null || data instanceof String && "".equals(data))) {
            return data;
        }
        data = localizedData.get(this.getCurrentLocale());
        if (!(null == data || data instanceof String && "".equals(data))) {
            return data;
        }
        data = localizedData.get(this.getDefaultLang());
        if (!(null == data || data instanceof String && "".equals(data))) {
            return data;
        }
        data = localizedData.get(this.getDefaultLocale());
        if (!(null == data || data instanceof String && "".equals(data))) {
            return data;
        }
        Set entries = localizedData.entrySet();
        return entries.iterator().next().getValue();
    }

    public static Locale currentLocale() {
        return LocaleManager.lookup().getCurrentLocale();
    }

    public static String currentLang() {
        return LocaleManager.lookup().getCurrentLang();
    }

    public ResourceBundle getBundle(String baseName) {
        return ResourceBundle.getBundle(baseName, this.fallbackControl);
    }

    public ResourceBundle getBundle(String baseName, Locale targetLocale) {
        return ResourceBundle.getBundle(baseName, targetLocale, this.fallbackControl);
    }

    public ResourceBundle getBundle(String baseName, Locale targetLocale, ClassLoader loader) {
        return ResourceBundle.getBundle(baseName, targetLocale, loader, this.fallbackControl);
    }
}

